/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.exchange.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipToFolder(File zipFile, File destination) throws ZipException, IOException {
        boolean unziped = false;
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                File file = new File(destination, entry.getName());
                if (entry.isDirectory()) {
                    file.getParentFile().mkdirs();
                    continue;
                }
                InputStream is = zip.getInputStream(entry);
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                FileOutputStream os = new FileOutputStream(file);
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                finally {
                    os.close();
                    is.close();
                }
                file.setLastModified(entry.getTime());
            }
            unziped = true;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zip);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)zip);
        return unziped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String downloadUrl, String filePath, String username, String password) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try (CloseableHttpClient httpclient = HttpClients.custom().build();){
            String userCredentials = username + ":" + password;
            String basicAuth = "Basic " + new Base64().encodeAsString(userCredentials.getBytes());
            HttpGet httpget = new HttpGet(downloadUrl);
            httpget.setHeader("Authorization", basicAuth);
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
                fileOutputStream.write(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                fileOutputStream.close();
            }
        }
    }

    public static HashMap<String, String> parseConnectorArtifact(String artifactFilePath, File tmpFolder) throws IOException, ParserConfigurationException, SAXException {
        Utils.unzipToFolder(new File(artifactFilePath), tmpFolder);
        File fXmlFile = new File(tmpFolder + File.separator + "feature.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        Document doc = dbFactory.newDocumentBuilder().parse(fXmlFile);
        Element featureElement = (Element)doc.getElementsByTagName("feature").item(0);
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        connectorAttributes.put("featureId", featureElement.getAttribute("id") + ".feature.group");
        connectorAttributes.put("minMuleVersion", Utils.obtainMinMuleVersion(featureElement.getAttribute("id")));
        connectorAttributes.put("notes", featureElement.getAttribute("label"));
        connectorAttributes.put("connectorVersion", featureElement.getAttribute("version"));
        return connectorAttributes;
    }

    public static String versionWithoutWatermark(String version) {
        Pattern pattern = Pattern.compile("^([0-9]+\\.[0-9]+\\.[0-9]+).*$");
        Matcher matcher = pattern.matcher(version);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String obtainMinMuleVersion(String featureId) {
        Pattern pattern = Pattern.compile("^.*([0-9]\\.[0-9])\\.0$");
        Matcher matcher = pattern.matcher(featureId);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

