# Argumentum
Argumentum is an option parser for node.

## Example
Example usage (in CoffeeScript):

```coffeescript
argumentum = require 'argumentum'

config =
  script: 'app'
  commandRequired: yes
  commands:
    new:
      help: 'Create new project'
      options:
        appPath:
          position: 1
          help: 'application path'
          metavar: 'APP_PATH'
          required: yes

        buildPath:
          abbr: 'o'
          help: 'build path'
          metavar: 'DIRECTORY'
          full: 'output'

      callback: (options) ->
        'callback called'

  options:
    version:
      abbr: 'v'
      help: 'display app version'
      flag: true
      callback: ->
        'version called'

argumentum.load(config).parse()
```

## Documentation


## License
This project is based on [nomnom](https://github.com/harthur/nomnom)
by Heather Arthur.

(The MIT License)

Copyright (c) 2011 Paul Miller (paulmillr.com)

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

