// Generated by CoffeeScript 1.2.1-pre
(function() {
  var ArgumentParser, argumentParser, booleanSetter, colorize, colors, extend, getColor, i, isEmptyObject, method, parseArgument, parseOption, path, setter, spaces,
    __slice = [].slice,
    __hasProp = {}.hasOwnProperty,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  path = require('path');

  colors = {
    black: 30,
    red: 31,
    green: 32,
    brown: 33,
    blue: 34,
    purple: 35,
    cyan: 36,
    gray: 37,
    none: '',
    reset: 0
  };

  getColor = function(color) {
    return colors[color.toString()] || colors.none;
  };

  colorize = function(text, color) {
    return "\x16[" + (getColor(color)) + "m" + text + "\x16[" + (getColor('reset')) + "m";
  };

  spaces = function(count) {
    return Array(+count + 1).join(' ');
  };

  setter = function(prop) {
    return function(val) {
      this[prop] = val;
      return this;
    };
  };

  booleanSetter = function(prop) {
    return function(val) {
      this[prop] = !!val;
      return this;
    };
  };

  extend = function() {
    var key, obj, object, objects, val, _i, _len;
    obj = arguments[0], objects = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
    for (_i = 0, _len = objects.length; _i < _len; _i++) {
      object = objects[_i];
      for (key in object) {
        if (!__hasProp.call(object, key)) continue;
        val = object[key];
        obj[key] = val;
      }
    }
    return obj;
  };

  isEmptyObject = function(object) {
    var key;
    for (key in object) {
      if (!__hasProp.call(object, key)) continue;
      return false;
    }
    return true;
  };

  parseArgument = function(str) {
    var charMatch, chars, full, fullMatch, isValue, value;
    charMatch = /^\-(\w+?)$/.exec(str);
    chars = charMatch && charMatch[1].split('');
    fullMatch = /^\-\-(no\-)?(.+?)(?:=(.+))?$/.exec(str);
    full = fullMatch && fullMatch[2];
    isValue = (str != null) && (str === '' || /^[^\-].*/.test(str));
    if (isValue) {
      value = str;
    } else if (full) {
      value = fullMatch[1] ? false : fullMatch[3];
    }
    return {
      str: str,
      chars: chars,
      full: full,
      value: value,
      isValue: isValue
    };
  };

  parseOption = function(opt) {
    var abbr, full, matches, metavar, name, string, strings, _i, _len;
    if (opt == null) opt = {};
    strings = (opt.string || '').split(',');
    for (_i = 0, _len = strings.length; _i < _len; _i++) {
      string = strings[_i];
      string = string.trim();
      if (matches = string.match(/^\-([^-])(?:\s+(.*))?$/)) {
        abbr = matches[1];
        metavar = matches[2];
      } else if (matches = string.match(/^\-\-(.+?)(?:[=\s]+(.+))?$/)) {
        full = matches[1];
        metavar || (metavar = matches[2]);
      }
    }
    matches || (matches = []);
    abbr = opt.abbr || abbr;
    full = opt.full || full;
    metavar = opt.metavar || metavar;
    if (opt.string) {
      string = opt.string;
    } else if (!(opt.position != null)) {
      string = '';
      if (abbr) {
        string += "-" + abbr;
        if (metavar) string += " " + metavar;
        string += ', ';
      }
      string += "--" + (full || opt.name);
      if (metavar) string += " " + metavar;
    }
    name = opt.name || full || abbr;
    return extend(opt, {
      name: name,
      string: string,
      abbr: abbr,
      full: full,
      metavar: metavar,
      matches: function(arg) {
        return (arg === opt.full || arg === opt.abbr || arg === opt.position || arg === opt.name) || (opt.list && arg >= opt.position);
      }
    });
  };

  ArgumentParser = (function() {

    ArgumentParser.name = 'ArgumentParser';

    function ArgumentParser() {
      if (!(this instanceof ArgumentParser)) {
        return (function(func, args, ctor) {
          ctor.prototype = func.prototype;
          var child = new ctor, result = func.apply(child, args);
          return typeof result === "object" ? result : child;
        })(ArgumentParser, arguments, function() {});
      }
      this.commands = {};
      this.commandAbbrs = {};
      this.specs = {};
    }

    ArgumentParser.prototype.command = function(name) {
      var chain, command,
        _this = this;
      if (name) {
        command = this.commands[name] = {
          name: name,
          specs: {}
        };
      } else {
        command = this.fallback = {
          specs: {}
        };
      }
      chain = {
        options: function(specs) {
          command.specs = specs;
          return chain;
        },
        option: function(name, spec) {
          command.specs[name] = spec;
          return chain;
        },
        callback: function(cb) {
          command.cb = cb;
          return chain;
        },
        help: function(help) {
          command.help = help;
          return chain;
        },
        usage: function(usage) {
          command._usage = usage;
          return chain;
        },
        abbr: function(abbr) {
          command.abbr = abbr;
          _this.commandAbbrs[abbr] = command;
          return chain;
        },
        opts: function(specs) {
          return this.options(specs);
        }
      };
      return chain;
    };

    ArgumentParser.prototype.nocommand = function() {
      return this.command();
    };

    ArgumentParser.prototype.options = setter("specs");

    ArgumentParser.prototype.usage = setter("_usage");

    ArgumentParser.prototype.printer = setter("print");

    ArgumentParser.prototype.script = setter("_script");

    ArgumentParser.prototype.help = setter("_help");

    ArgumentParser.prototype.withColors = booleanSetter("_withColors");

    ArgumentParser.prototype.commandRequired = booleanSetter("_commandRequired");

    ArgumentParser.prototype.option = function(name, spec) {
      this.specs[name] = spec;
      return this;
    };

    ArgumentParser.prototype._colorize = function(text, color) {
      if (this._withColors) {
        return colorize(text, color);
      } else {
        return text;
      }
    };

    ArgumentParser.prototype.getUsage = function() {
      var command, indent, longest, name, options, pos, posStr, positionals, str, visible, _i, _j, _len, _len2, _ref,
        _this = this;
      if (this.command && this.command._usage) return this.command._usage;
      if (this.fallback && this.fallback._usage) return this.fallback._usage;
      if (this._usage) return this._usage;
      indent = function(str) {
        return spaces(2) + str;
      };
      str = "Usage: " + this._script;
      positionals = this.specs.filter(function(opt) {
        return opt.position != null;
      }).sort(function(left, right) {
        return left.position > right.position;
      });
      options = this.specs.filter(function(opt) {
        return !(opt.position != null);
      });
      if (positionals.length) {
        for (_i = 0, _len = positionals.length; _i < _len; _i++) {
          pos = positionals[_i];
          str += ' ';
          posStr = pos.string || ("<" + (pos.name || ("arg" + pos.position)) + ">" + [pos.list ? '...' : void 0]);
          str += posStr;
        }
      } else if (this._printAllCommands) {
        str += ' [command] [options]';
        str += '\n\nPossible commands are:\n';
        _ref = this.commands;
        for (name in _ref) {
          command = _ref[name];
          str += indent("" + this._script + " " + command.name);
          if (command.help) str += ": " + command.help;
          if (command.abbr) str += " (short-cut alias: '" + command.abbr + "')";
          str += '\n';
        }
        str += "\nTo get help on individual command, execute '" + this._script + " <command> --help'";
      }
      if (options.length) str += this._colorize(' [options]', 'blue');
      if (options.length || positionals.length) str += '\n\n';
      longest = positionals.reduce((function(max, pos) {
        return Math.max(max, pos.name.length);
      }), 0);
      for (_j = 0, _len2 = positionals.length; _j < _len2; _j++) {
        pos = positionals[_j];
        posStr = pos.string || pos.name;
        str += posStr + spaces(longest - posStr.length + 5);
        str += this._colorize(pos.help || '', 'gray');
        str += '\n';
      }
      if (positionals.length && options.length) str += '\n';
      if (options.length) {
        visible = function(opt) {
          return !opt.hidden;
        };
        str += this._colorize('Options:\n', 'blue');
        longest = options.filter(visible).reduce((function(max, opt) {
          return Math.max(max, opt.string.length);
        }), 0);
        str += options.filter(visible).map(function(opt) {
          var help, indentation;
          indentation = spaces(longest - opt.string.length);
          help = _this._colorize(opt.help || '', 'gray');
          return indent("" + opt.string + " " + indentation + " " + help);
        }).join('\n');
      }
      if (this._help) str += "\n\nDescription:\n" + (indent(this._help));
      return str;
    };

    ArgumentParser.prototype.parse = function(argv) {
      var arg, args, command, commandExpected, index, key, message, opt, options, pos, positionals, value, _i, _j, _len, _len2, _ref, _ref2,
        _this = this;
      if (this.print == null) {
        this.print = function(str) {
          console.log(str);
          return process.exit(0);
        };
      }
      if (this._help == null) this._help = '';
      if (this._script == null) {
        this._script = "" + process.argv[0] + " " + (path.basename(process.argv[1]));
      }
      if (this.specs == null) this.specs = {};
      if (this._commandRequired && !process.argv[2]) process.argv[2] = '--help';
      if (argv == null) argv = process.argv.slice(2);
      arg = parseArgument(argv[0]).isValue && argv[0];
      command = arg && this.commands[arg] || this.commandAbbrs[arg];
      commandExpected = !isEmptyObject(this.commands);
      if (commandExpected) {
        if (command) {
          extend(this.specs, command.specs);
          this._script += " " + command.name;
          if (command.help) this._help = command.help;
          this.command = command;
        } else if (arg) {
          return this.print("" + this._script + ": no such command '" + arg + "'");
        } else {
          this._printAllCommands = true;
          if (this.fallback) {
            extend(this.specs, this.fallback.specs);
            this._help = this.fallback.help;
          }
        }
      }
      if (!this.specs.length) {
        this.specs = (function() {
          var _ref, _results;
          _ref = this.specs;
          _results = [];
          for (key in _ref) {
            value = _ref[key];
            value.name = key;
            _results.push(value);
          }
          return _results;
        }).call(this);
      }
      this.specs = this.specs.map(parseOption);
      if (__indexOf.call(argv, '--help') >= 0 || __indexOf.call(argv, '-h') >= 0) {
        return this.print(this.getUsage());
      }
      options = {};
      args = argv.map(parseArgument).concat(parseArgument());
      positionals = [];
      args.reduce(function(arg, val) {
        var ch, last, _i, _len, _ref;
        if (arg.isValue) {
          positionals.push(arg.value);
        } else if (arg.chars) {
          last = arg.chars.pop();
          _ref = arg.chars;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            ch = _ref[_i];
            _this.setOption(options, ch, true);
          }
          if (_this.opt(last).flag) {
            _this.setOption(options, last, true);
          } else if (val.isValue) {
            _this.setOption(options, last, val.value);
            return parseArgument();
          } else {
            _this.print("'-" + (_this.opt(last).name || last) + "' expects a value\n\n" + (_this.getUsage()));
          }
        } else if (arg.full) {
          value = arg.value;
          if (value == null) {
            if (_this.opt(arg.full).flag) {
              value = true;
            } else if (val.isValue) {
              _this.setOption(options, arg.full, val.value);
              return parseArgument();
            } else {
              _this.print("'--" + (_this.opt(arg.full).name || arg.full) + "' expects a value\n\n" + (_this.getUsage()));
            }
          }
          _this.setOption(options, arg.full, value);
        }
        return val;
      });
      for (index = _i = 0, _len = positionals.length; _i < _len; index = ++_i) {
        pos = positionals[index];
        this.setOption(options, index, pos);
      }
      _ref = this.specs;
      for (_j = 0, _len2 = _ref.length; _j < _len2; _j++) {
        opt = _ref[_j];
        if (!(options[opt.name] != null)) {
          if (opt["default"] != null) {
            options[opt.name] = opt["default"];
          } else if (opt.required) {
            this.print("" + opt.name + " argument is required\n\n" + (this.getUsage()));
          }
        }
      }
      if ((command != null ? command.cb : void 0) != null) {
        message = command.cb(options);
        if (typeof message === 'string') this.print(message);
      } else if (((_ref2 = this.fallback) != null ? _ref2.cb : void 0) != null) {
        this.fallback.cb(options);
      }
      return options;
    };

    ArgumentParser.prototype.opt = function(arg) {
      var match, opt, _i, _len, _ref;
      match = parseOption();
      _ref = this.specs;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        opt = _ref[_i];
        if (opt.matches(arg)) match = opt;
      }
      return match;
    };

    ArgumentParser.prototype.setOption = function(options, arg, value) {
      var message, name, option;
      option = this.opt(arg);
      if (option.callback) {
        message = option.callback(value);
        if (typeof message === 'string') this.print(message);
      }
      if (option.type !== 'string') {
        try {
          value = JSON.parse(value);
        } catch (_error) {}
      }
      name = option.name || arg;
      if (option.choices && __indexOf.call(option.choices, value) < 0) {
        this.print("" + name + " must be one of: " + (option.choices.join(', ')));
      }
      if (option.list) {
        if (options[name] == null) options[name] = [];
        return options[name].push(value);
      } else {
        return options[name] = value;
      }
    };

    ArgumentParser.prototype.parseArgs = function() {
      return this.parse.apply(this, arguments);
    };

    ArgumentParser.prototype.scriptName = function() {
      return this.script.apply(this, arguments);
    };

    ArgumentParser.prototype.globalOpts = function() {
      return this.options.apply(this, arguments);
    };

    ArgumentParser.prototype.opts = function() {
      return this.options.apply(this, arguments);
    };

    ArgumentParser.prototype.colors = function() {
      return this.withColors.apply(this, arguments);
    };

    ArgumentParser.prototype.nom = function(argv) {
      return this.parse(argv);
    };

    ArgumentParser.prototype.load = function(config) {
      var attrName, attrValue, command, commandData, commandName, data, name;
      for (name in config) {
        if (!__hasProp.call(config, name)) continue;
        data = config[name];
        if (name === 'commands') {
          for (commandName in data) {
            if (!__hasProp.call(data, commandName)) continue;
            commandData = data[commandName];
            command = this.command(commandName);
            for (attrName in commandData) {
              if (!__hasProp.call(commandData, attrName)) continue;
              attrValue = commandData[attrName];
              command[attrName](attrValue);
            }
          }
        } else {
          try {
            if (typeof data === 'function') data = data(this);
            this[name](data);
          } catch (error) {

          }
        }
      }
      return this;
    };

    return ArgumentParser;

  })();

  argumentParser = new ArgumentParser;

  for (i in argumentParser) {
    method = argumentParser[i];
    if (typeof method === 'function') {
      ArgumentParser[i] = method.bind(argumentParser);
    }
  }

  exports.ArgumentParser = ArgumentParser;

  exports.load = function(config) {
    return (new ArgumentParser).load(config);
  };

}).call(this);
