// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var cloneSkeleton, copySkeleton, create, exec, fs_utils, helpers, logger, mkdirp, rimraf, sysPath;

  exec = require('child_process').exec;

  mkdirp = require('mkdirp');

  sysPath = require('path');

  rimraf = require('rimraf');

  helpers = require('../helpers');

  logger = require('../logger');

  fs_utils = require('../fs_utils');

  copySkeleton = function(skeletonPath, rootPath, callback) {
    var copyDirectory, skeletonDir;
    skeletonDir = sysPath.join(__dirname, '..', '..', 'skeletons');
    if (skeletonPath == null) {
      skeletonPath = sysPath.join(skeletonDir, 'brunch-with-chaplin');
    }
    logger.debug('info', "Copying skeleton from " + skeletonPath);
    copyDirectory = function(from) {
      return fs_utils.copyIfExists(from, rootPath, false, function(error) {
        if (error != null) {
          return logger.error(error);
        }
        logger.info('Created brunch directory layout');
        return helpers.install(rootPath, callback);
      });
    };
    return mkdirp(rootPath, 0x1ed, function(error) {
      if (error != null) {
        return logger.error(error);
      }
      return fs_utils.exists(skeletonPath, function(exists) {
        if (!exists) {
          return logger.error("Skeleton '" + skeletonPath + "' doesn't exist");
        }
        return copyDirectory(skeletonPath);
      });
    });
  };

  cloneSkeleton = function(address, rootPath, isGitHubUrl, callback) {
    var URL;
    URL = isGitHubUrl ? "git://github.com/" + (address.replace('github://', '')) + ".git" : address;
    logger.debug('info', "Cloning skeleton from git URL " + URL);
    return exec("git clone " + URL + " " + rootPath, function(error, stdout, stderr) {
      if (error != null) {
        return logger.error("Git clone error: " + (stderr.toString()));
      }
      logger.info('Created brunch directory layout');
      return rimraf(sysPath.join(rootPath, '.git'), function(error) {
        if (error != null) {
          return logger.error(error);
        }
        return helpers.install(rootPath, callback);
      });
    });
  };

  module.exports = create = function(options, callback) {
    var re, rootPath, skeleton;
    if (callback == null) {
      callback = (function() {});
    }
    rootPath = options.rootPath, skeleton = options.skeleton;
    re = /(?:https?|git(hub)?)(?::\/\/|@)/;
    return fs_utils.exists(sysPath.join(rootPath, 'package.json'), function(exists) {
      var isGitHubUrl, isGitUrl;
      if (exists) {
        return logger.error("Directory '" + rootPath + "' is already an npm project");
      }
      isGitUrl = skeleton != null ? skeleton.match(re) : void 0;
      isGitHubUrl = Boolean(isGitUrl != null ? isGitUrl[1] : void 0);
      if (isGitUrl) {
        return cloneSkeleton(skeleton, rootPath, isGitHubUrl, callback);
      } else {
        return copySkeleton(skeleton, rootPath, callback);
      }
    });
  };

}).call(this);
