// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var async, destroyFile, formatGeneratorConfig, fs, fs_utils, generateFile, generateFiles, getDependencyTree, helpers, inflection, isDirectory, logger, mkdirp, os, readGeneratorConfig, scaffold, scaffoldFile, scaffoldFiles, sysPath, walk;

  async = require('async');

  fs = require('fs');

  inflection = require('inflection');

  mkdirp = require('mkdirp');

  os = require('os');

  sysPath = require('path');

  walk = require('walk');

  helpers = require('../helpers');

  logger = require('../logger');

  fs_utils = require('../fs_utils');

  generateFile = function(path, data, callback) {
    var parentDir, write;
    parentDir = sysPath.dirname(path);
    write = function() {
      logger.info("create " + path);
      return fs.writeFile(path, data, callback);
    };
    return fs_utils.exists(parentDir, function(exists) {
      if (exists) {
        return write();
      }
      logger.info("init " + parentDir);
      return mkdirp(parentDir, 0x1ed, function(error) {
        if (error != null) {
          return logger.error;
        }
        return write();
      });
    });
  };

  destroyFile = function(path, callback) {
    return fs.unlink(path, function(error) {
      if (error != null) {
        return logger.error("" + error);
      }
      logger.info("destroy " + path);
      return callback(error);
    });
  };

  scaffoldFile = function(rollback, from, to, templateData, callback) {
    if (rollback) {
      return destroyFile(to, callback);
    } else {
      return fs.readFile(from, function(error, buffer) {
        var formatted;
        formatted = (function() {
          try {
            return helpers.formatTemplate(buffer.toString(), templateData);
          } catch (error) {
            return buffer;
          }
        })();
        return generateFile(to, formatted, callback);
      });
    }
  };

  scaffoldFiles = function(rollback, templateData) {
    return function(generator, callback) {
      return async.forEach(generator.files, function(_arg, callback) {
        var from, to;
        from = _arg.from, to = _arg.to;
        return scaffoldFile(rollback, from, to, templateData, callback);
      }, callback);
    };
  };

  isDirectory = function(generatorsPath) {
    return function(path, callback) {
      return fs.stat(sysPath.join(generatorsPath, path), function(error, stats) {
        if (error != null) {
          logger.error(error);
        }
        return callback(stats.isDirectory());
      });
    };
  };

  readGeneratorConfig = function(generatorsPath) {
    return function(name, callback) {
      var path;
      path = sysPath.join(generatorsPath, name, 'generator.json');
      return fs.readFile(path, function(error, buffer) {
        var data, json;
        if (error != null) {
          return callback(error);
        }
        data = buffer.toString();
        try {
          json = JSON.parse(data);
        } catch (error) {
          throw new Error("Invalid json at " + path + ": " + error);
        }
        json.name = name;
        return callback(null, json);
      });
    };
  };

  formatGeneratorConfig = function(path, json, templateData) {
    var join, replaceSlashes;
    join = function(file) {
      return sysPath.join(path, file);
    };
    replaceSlashes = function(string) {
      if (os.platform() === 'win32') {
        return string.replace(/\//g, '\\');
      } else {
        return string;
      }
    };
    json.files = json.files.map(function(object) {
      return {
        from: join(replaceSlashes(object.from)),
        to: replaceSlashes(helpers.formatTemplate(object.to, templateData))
      };
    });
    json.dependencies = json.dependencies.map(function(object) {
      return {
        name: object.name,
        params: helpers.formatTemplate(object.params, templateData)
      };
    });
    return Object.freeze(json);
  };

  getDependencyTree = function(generators, generatorName, memo) {
    var generator, _ref;
    if (memo == null) {
      memo = [];
    }
    generator = generators.filter(function(gen) {
      return gen.name === generatorName;
    })[0];
    if (generator == null) {
      throw new Error("Invalid generator " + generatorName);
    }
    ((_ref = generator.dependencies) != null ? _ref : []).forEach(function(dependency) {
      return getDependencyTree(generators, dependency.name, memo);
    });
    memo.push(generator);
    return memo;
  };

  generateFiles = function(rollback, generatorsPath, type, templateData, callback) {
    return fs.readdir(generatorsPath, function(error, files) {
      if (error != null) {
        throw new Error(error);
      }
      return async.filter(files, isDirectory(generatorsPath), function(directories) {
        return async.map(directories, readGeneratorConfig(generatorsPath), function(error, configs) {
          var generators, tree;
          if (error != null) {
            throw new Error(error);
          }
          generators = directories.map(function(directory, index) {
            var path;
            path = sysPath.join(generatorsPath, directory);
            return formatGeneratorConfig(path, configs[index], templateData);
          });
          tree = getDependencyTree(generators, type);
          return async.forEach(tree, scaffoldFiles(rollback, templateData), function(error) {
            if (error != null) {
              return callback(error);
            }
            return callback();
          });
        });
      });
    });
  };

  module.exports = scaffold = function(rollback, options, callback) {
    var configPath, name, parentDir, pluralName, type;
    if (callback == null) {
      callback = (function() {});
    }
    type = options.type, name = options.name, pluralName = options.pluralName, parentDir = options.parentDir, configPath = options.configPath;
    pluralName = inflection.pluralize(name);
    return helpers.loadPackages(helpers.pwd(), function(error, packages) {
      var config, generators, templateData;
      if (error != null) {
        return logger.error(error);
      }
      config = helpers.loadConfig(configPath);
      if (config == null) {
        return callback();
      }
      generators = config.paths.generators;
      templateData = {
        name: name,
        pluralName: pluralName
      };
      return generateFiles(rollback, generators, type, templateData, function(error) {
        if (error != null) {
          return logger.error(error);
        }
        return callback();
      });
    });
  };

}).call(this);
