// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var Mocha, async, findTestHelpersFile, fs, fs_utils, getScriptFilesPath, helpers, loadJsdom, os, readTestFiles, safeRequire, setupJsDom, showJsdomNote, startBrunchTestRunner, startMocha, sysPath, test, watch,
    __slice = [].slice;

  os = require('os');

  fs = require('fs');

  sysPath = require('path');

  async = require('async');

  Mocha = require('mocha');

  fs_utils = require('../fs_utils');

  helpers = require('../helpers');

  watch = require('./watch');

  showJsdomNote = function() {
    var osMessage;
    osMessage = function() {
      if (os.platform() === 'win32') {
        return "\nBefore installing jsdom, you have to install the following dependencies:\n* Python 2.7\n* Microsoft Visual Studio or Visual C++ Express\n\nOnce you have installed the dependencies, enter the following in your terminal (in the current directory):";
      } else {
        return "In order to run tests in a CLI/jsdom environment, you have to install jsdom.";
      }
    };
    return console.log("\n\n" + (osMessage()) + "\n\na) Install jsdom for all system packages (recommended):\n  * Execute `npm install -g jsdom`\n  * Add the parent dir of jsdom to NODE_PATH environment var,\n  like `export NODE_PATH=/usr/local/lib/node_modules`\nb) Install jsdom locally for this project:\n  * Execute `npm install jsdom`");
  };

  safeRequire = function(module) {
    try {
      return require(module);
    } catch (_error) {}
  };

  loadJsdom = function() {
    var altPath, jsdom;
    altPath = './node_modules/jsdom';
    jsdom = safeRequire('jsdom') || safeRequire(sysPath.resolve(altPath));
    if (jsdom) {
      return jsdom;
    } else {
      showJsdomNote();
      return process.exit(1);
    }
  };

  getScriptFilesPath = function(htmlFile, callback) {
    var document, window;
    document = loadJsdom().jsdom(htmlFile, null, {
      features: {
        QuerySelector: true
      }
    });
    window = document.createWindow();
    return window.document.querySelectorAll('script[src]').map(function(script) {
      return script.src;
    });
  };

  readTestFiles = function(publicPath, callback) {
    var getPublicPath;
    getPublicPath = function() {
      var subPaths;
      subPaths = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return sysPath.join.apply(sysPath, [publicPath].concat(__slice.call(subPaths)));
    };
    return fs.readFile(getPublicPath('index.html'), function(error, buffer) {
      var htmlFile, scriptFilesPath;
      if (error != null) {
        throw error;
      }
      htmlFile = buffer.toString();
      scriptFilesPath = getScriptFilesPath(htmlFile).map(getPublicPath);
      return async.map(scriptFilesPath, fs.readFile, function(error, buffers) {
        var scripts;
        if (error != null) {
          return callback(error);
        }
        scripts = buffers.filter(function(buffer) {
          return buffer != null;
        }).map(function(buffer) {
          return buffer.toString();
        });
        return callback(null, htmlFile, scripts);
      });
    });
  };

  setupJsDom = function(publicPath, callback) {
    return readTestFiles(publicPath, function(error, htmlFile, scriptFiles) {
      if (error != null) {
        throw error;
      }
      return loadJsdom().env({
        html: htmlFile,
        src: scriptFiles,
        done: function(error, window) {
          if (error != null) {
            throw error;
          }
          return callback(window);
        }
      });
    });
  };

  startMocha = function(config, options, testFiles, globals) {
    var mocha, _ref, _ref1, _ref2;
    helpers.extend(global, globals);
    mocha = new Mocha();
    mocha.reporter(options.reporter || ((_ref2 = config.test) != null ? _ref2.reporter : void 0) || 'spec').ui((_ref = (_ref1 = config.test) != null ? _ref1.ui : void 0) != null ? _ref : 'bdd');
    testFiles.forEach(function(file) {
      return mocha.addFile(file);
    });
    return mocha.run(function(failures) {
      return process.exit((failures > 0 ? 1 : 0));
    });
  };

  findTestHelpersFile = function(testPath, callback) {
    return fs.readdir(testPath, function(error, files) {
      var testHelpers;
      if (error != null) {
        throw error;
      }
      testHelpers = files.filter(function(file) {
        return /^test[-_]helpers?\./.test(file);
      });
      if (testHelpers.length > 0) {
        return callback(sysPath.resolve(sysPath.join(testPath, testHelpers[0])));
      } else {
        return callback(null);
      }
    });
  };

  startBrunchTestRunner = function(config, options) {
    var testFiles,
      _this = this;
    testFiles = helpers.findTestFiles(config);
    if (testFiles.length === 0) {
      throw new Error("Can't find tests for this project.");
    }
    return setupJsDom(config.paths["public"], function(window) {
      return findTestHelpersFile(config.paths.test, function(testHelpersFile) {
        var globals;
        globals = testHelpersFile != null ? require(testHelpersFile) : {};
        globals.window = window;
        return startMocha(config, options, testFiles, globals);
      });
    });
  };

  module.exports = test = function(options) {
    var watcher;
    return watcher = watch(true, options, function() {
      return startBrunchTestRunner(watcher.config, options);
    });
  };

}).call(this);
