// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var BrunchWatcher, async, bindWatcherEvents, changeFileList, chokidar, fs_utils, generateParams, getCompileFn, getPluginIncludes, getReloadFn, helpers, initWatcher, initialize, isFunction, isPluginFor, logger, propIsFunction, sysPath, watch,
    __slice = [].slice,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  async = require('async');

  chokidar = require('chokidar');

  sysPath = require('path');

  helpers = require('../helpers');

  logger = require('../logger');

  fs_utils = require('../fs_utils');

  getPluginIncludes = function(plugins) {
    return plugins.map(function(plugin) {
      return plugin.include;
    }).map(helpers.callFunctionOrPass).filter(function(paths) {
      return paths != null;
    }).reduce((function(acc, elem) {
      return acc.concat(helpers.ensureArray(elem));
    }), []);
  };

  isFunction = function(item) {
    return typeof item === 'function';
  };

  propIsFunction = function(prop) {
    return function(object) {
      return isFunction(object[prop]);
    };
  };

  generateParams = function(persistent, options) {
    var params;
    params = {};
    params.minify = Boolean(options.minify);
    params.persistent = persistent;
    if (options.publicPath) {
      params.paths = {};
      params.paths["public"] = options.publicPath;
    }
    if (persistent) {
      params.server = {};
      if (options.server) {
        params.server.run = true;
      }
      if (options.port) {
        params.server.port = options.port;
      }
    }
    return params;
  };

  initWatcher = function(config, callback) {
    var watched;
    watched = [config.paths.app, config.paths.test, config.paths.vendor, config.paths.assets, config.paths.config, config.paths.packageConfig];
    return async.filter(watched, fs_utils.exists, function(watchedFiles) {
      var watcher;
      watcher = chokidar.watch(watchedFiles, {
        ignored: fs_utils.ignored,
        persistent: config.persistent
      });
      watcher.on('add', function(path) {
        return logger.debug('watcher', "File '" + path + "' received event 'add'");
      }).on('change', function(path) {
        return logger.debug('watcher', "File '" + path + "' received event 'change'");
      }).on('unlink', function(path) {
        return logger.debug('watcher', "File '" + path + "' received event 'unlink'");
      }).on('error', logger.error);
      return callback(null, watcher);
    });
  };

  isPluginFor = function(path) {
    return function(plugin) {
      var pattern;
      pattern = plugin.pattern ? plugin.pattern : plugin.extension ? RegExp("\\." + plugin.extension + "$") : /$.^/;
      return pattern.test(path);
    };
  };

  changeFileList = function(compilers, linters, fileList, path, isHelper) {
    var compiler, currentLinters;
    compiler = compilers.filter(isPluginFor(path))[0];
    currentLinters = linters.filter(isPluginFor(path));
    return fileList.emit('change', path, compiler, currentLinters, isHelper);
  };

  getCompileFn = function(config, joinConfig, fileList, minifiers, watcher, callback) {
    return function(startTime) {
      var assetErrors;
      assetErrors = fileList.getAssetErrors();
      if (assetErrors != null) {
        assetErrors.forEach(function(error) {
          return logger.error(error);
        });
        return;
      }
      return fs_utils.write(fileList, config, joinConfig, minifiers, startTime, function(error, generatedFiles) {
        if (error != null) {
          if (Array.isArray(error)) {
            error.forEach(function(subError) {
              return logger.error(subError);
            });
          } else {
            logger.error(error);
          }
          return;
        }
        logger.info("compiled in " + (Date.now() - startTime) + "ms");
        if (!config.persistent) {
          watcher.close();
          process.on('exit', function(previousCode) {
            return process.exit((logger.errorHappened ? 1 : previousCode));
          });
        }
        return callback(generatedFiles);
      });
    };
  };

  getReloadFn = function(config, options, onCompile, watcher, server) {
    return function(reInstall) {
      var reWatch;
      reWatch = function() {
        if (server != null) {
          if (typeof server.close === "function") {
            server.close();
          }
        }
        watcher.close();
        return watch(config.persistent, options, onCompile);
      };
      if (reInstall) {
        return helpers.install(config.paths.root, reWatch);
      } else {
        return reWatch();
      }
    };
  };

  initialize = function(options, configParams, onCompile, callback) {
    return helpers.loadPackages(helpers.pwd(), function(error, packages) {
      var callCompileCallbacks, callbacks, compilers, config, fileList, joinConfig, linters, minifiers, plugins, server;
      if (error != null) {
        return callback(error);
      }
      config = helpers.loadConfig(options.configPath, configParams);
      joinConfig = config._normalized.join;
      plugins = helpers.getPlugins(packages, config);
      compilers = plugins.filter(propIsFunction('compile'));
      linters = plugins.filter(propIsFunction('lint'));
      minifiers = plugins.filter(propIsFunction('minify'));
      callbacks = plugins.filter(propIsFunction('onCompile')).map(function(plugin) {
        return function() {
          var args;
          args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
          return plugin.onCompile.apply(plugin, args);
        };
      });
      callbacks.push(onCompile);
      callCompileCallbacks = function(generatedFiles) {
        return callbacks.forEach(function(callback) {
          return callback(generatedFiles);
        });
      };
      fileList = new fs_utils.FileList(config);
      if (config.persistent && config.server.run) {
        server = helpers.startServer(config);
      }
      getPluginIncludes(plugins).forEach(function(path) {
        return changeFileList(compilers, linters, fileList, path, true);
      });
      return initWatcher(config, function(error, watcher) {
        var compile, reload;
        if (error != null) {
          return callback(error);
        }
        compile = getCompileFn(config, joinConfig, fileList, minifiers, watcher, callCompileCallbacks);
        reload = getReloadFn(config, options, onCompile, watcher, server);
        return callback(error, {
          config: config,
          watcher: watcher,
          server: server,
          fileList: fileList,
          compilers: compilers,
          linters: linters,
          compile: compile,
          reload: reload
        });
      });
    });
  };

  bindWatcherEvents = function(config, fileList, compilers, linters, watcher, reload, onChange) {
    return watcher.on('add', function(path) {
      onChange();
      return changeFileList(compilers, linters, fileList, path, false);
    }).on('change', function(path) {
      if (path === config.paths.config) {
        return reload(false);
      } else if (path === config.paths.packageConfig) {
        return reload(true);
      } else {
        onChange();
        return changeFileList(compilers, linters, fileList, path, false);
      }
    }).on('unlink', function(path) {
      if (path === config.paths.config || path === config.paths.packageConfig) {
        logger.info("Detected removal of config.coffee / package.json.Exiting.");
        return process.exit(0);
      } else {
        onChange();
        return fileList.emit('unlink', path);
      }
    });
  };

  BrunchWatcher = (function() {

    function BrunchWatcher(persistent, options, onCompile) {
      this._endCompilation = __bind(this._endCompilation, this);

      this._startCompilation = __bind(this._startCompilation, this);

      var configParams,
        _this = this;
      configParams = generateParams(persistent, options);
      initialize(options, configParams, onCompile, function(error, result) {
        var compile, compilers, config, fileList, linters, reload, watcher;
        if (error != null) {
          return logger.error(error);
        }
        config = result.config, watcher = result.watcher, fileList = result.fileList, compilers = result.compilers, linters = result.linters, compile = result.compile, reload = result.reload;
        logger.notifications = config.notifications;
        bindWatcherEvents(config, fileList, compilers, linters, watcher, reload, _this._startCompilation);
        fileList.on('ready', function() {
          return compile(_this._endCompilation());
        });
        return _this.config = config;
      });
    }

    BrunchWatcher.prototype._startCompilation = function() {
      var _ref;
      return (_ref = this._start) != null ? _ref : this._start = Date.now();
    };

    BrunchWatcher.prototype._endCompilation = function() {
      var start;
      start = this._start;
      this._start = null;
      return start;
    };

    return BrunchWatcher;

  })();

  module.exports = watch = function(persistent, options, callback) {
    if (callback == null) {
      callback = (function() {});
    }
    return new BrunchWatcher(persistent, options, callback);
  };

}).call(this);
