// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var Asset, common, getAssetDirectory, helpers, logger, ncp, sysPath;

  sysPath = require('path');

  helpers = require('../helpers');

  logger = require('../logger');

  common = require('./common');

  ncp = require('ncp').ncp;

  getAssetDirectory = function(path, convention) {
    var splitted;
    splitted = path.split(common.sep);
    return splitted.map(function(part, index) {
      var current, previous;
      previous = index === 0 ? '' : splitted[index - 1] + common.sep;
      current = part + common.sep;
      return previous + current;
    }).filter(convention)[0];
  };

  module.exports = Asset = (function() {

    function Asset(path, config) {
      var directory;
      this.path = path;
      directory = getAssetDirectory(this.path, config._normalized.conventions.assets);
      this.relativePath = sysPath.relative(directory, this.path);
      this.destinationPath = sysPath.join(config.paths["public"], this.relativePath);
      logger.debug('asset', "Initializing fs_utils.Asset", {
        path: this.path,
        directory: directory,
        relativePath: this.relativePath,
        destinationPath: this.destinationPath
      });
      this.error = null;
      Object.seal(this);
    }

    Asset.prototype.copy = function(callback) {
      var _this = this;
      return common.copy(this.path, this.destinationPath, function(error) {
        var err;
        if (error != null) {
          err = new Error(error);
          err.brunchType = 'Copying';
          _this.error = err;
        } else {
          _this.error = null;
        }
        return callback(_this.error);
      });
    };

    return Asset;

  })();

}).call(this);
