// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var EventEmitter, fs, ignored, ignoredAlways, logger, mkdirp, ncp, os, sysPath;

  fs = require('fs');

  EventEmitter = require('events').EventEmitter;

  mkdirp = require('mkdirp');

  ncp = require('ncp').ncp;

  os = require('os');

  sysPath = require('path');

  logger = require('../logger');

  exports.exists = fs.exists || sysPath.exists;

  exports.sep = sysPath.sep || (os.platform() === 'win32' ? '\\' : '/');

  exports.writeFile = function(path, data, callback) {
    var write;
    logger.debug('writer', "Writing file '" + path + "'");
    write = function(callback) {
      return fs.writeFile(path, data, callback);
    };
    return write(function(error) {
      if (error == null) {
        return callback(null, path, data);
      }
      return mkdirp(sysPath.dirname(path), 0x1ed, function(error) {
        if (error != null) {
          return callback(error);
        }
        return write(function(error) {
          return callback(error, path, data);
        });
      });
    });
  };

  exports.ignored = ignored = function(path) {
    return /(^[.#]|(?:__|~)$)/.test(sysPath.basename(path));
  };

  exports.ignoredAlways = ignoredAlways = function(path) {
    return /^\.(git|hg)$/.test(sysPath.basename(path));
  };

  exports.copy = function(source, destination, callback) {
    var copy, parentDir;
    if (ignored(source)) {
      return callback();
    }
    copy = function(error) {
      var input, output, request;
      if (error != null) {
        return callback(error);
      }
      input = fs.createReadStream(source);
      output = fs.createWriteStream(destination);
      request = input.pipe(output);
      return request.on('close', callback);
    };
    parentDir = sysPath.dirname(destination);
    return exports.exists(parentDir, function(exists) {
      if (exists) {
        return copy();
      } else {
        return mkdirp(parentDir, copy);
      }
    });
  };

  exports.copyIfExists = function(source, destination, filter, callback) {
    var options;
    if (filter == null) {
      filter = true;
    }
    options = filter ? {
      filter: function(path) {
        return !ignored(path);
      }
    } : {
      filter: function(path) {
        return !ignoredAlways(path);
      }
    };
    options.stopOnError = true;
    return exports.exists(source, function(exists) {
      if (!exists) {
        return callback();
      }
      return ncp(source, destination, options, callback);
    });
  };

}).call(this);
