// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var Asset, EventEmitter, FileList, SourceFile, helpers, logger, sysPath,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  EventEmitter = require('events').EventEmitter;

  Asset = require('./asset');

  SourceFile = require('./source_file');

  helpers = require('../helpers');

  logger = require('../logger');

  sysPath = require('path');

  module.exports = FileList = (function(_super) {

    __extends(FileList, _super);

    FileList.prototype.RESET_TIME = 65;

    function FileList(config) {
      this.config = config;
      this._unlink = __bind(this._unlink, this);

      this._change = __bind(this._change, this);

      this._copy = __bind(this._copy, this);

      this._compile = __bind(this._compile, this);

      this._resetTimer = __bind(this._resetTimer, this);

      this.files = [];
      this.assets = [];
      this.on('change', this._change);
      this.on('unlink', this._unlink);
      this.compiling = [];
      this.copying = [];
    }

    FileList.prototype.getAssetErrors = function() {
      var invalidAssets;
      invalidAssets = this.assets.filter(function(asset) {
        return asset.error != null;
      });
      if (invalidAssets.length > 0) {
        return invalidAssets.map(function(invalidAsset) {
          return helpers.formatError(invalidAsset.error, invalidAsset.path);
        });
      } else {
        return null;
      }
    };

    FileList.prototype._ignored = function(path, test) {
      var _this = this;
      if (test == null) {
        test = this.config.conventions.ignored;
      }
      if (path === this.config.paths.config || path === this.config.paths.packageConfig) {
        return true;
      }
      switch (toString.call(test)) {
        case '[object RegExp]':
          return path.match(test);
        case '[object Function]':
          return test(path);
        case '[object String]':
          return helpers.startsWith(sysPath.normalize(path), sysPath.normalize(test));
        case '[object Array]':
          return test.some(function(subTest) {
            return _this._ignored(path, subTest);
          });
        default:
          return false;
      }
    };

    FileList.prototype._isAsset = function(path) {
      return this.config._normalized.conventions.assets(path);
    };

    FileList.prototype._isVendor = function(path) {
      return this.config._normalized.conventions.vendor(path);
    };

    FileList.prototype._resetTimer = function() {
      var _this = this;
      if (this.timer != null) {
        clearTimeout(this.timer);
      }
      return this.timer = setTimeout(function() {
        if (_this.compiling.length === 0 && _this.copying.length === 0) {
          return _this.emit('ready');
        } else {
          return _this._resetTimer();
        }
      }, this.RESET_TIME);
    };

    FileList.prototype._findByPath = function(path) {
      return this.files.filter(function(file) {
        return file.path === path;
      })[0];
    };

    FileList.prototype._findAssetByPath = function(path) {
      return this.assets.filter(function(file) {
        return file.path === path;
      })[0];
    };

    FileList.prototype._compileDependentFiles = function(path) {
      var _this = this;
      return this.files.filter(function(dependent) {
        return dependent.cache.dependencies.length > 0;
      }).filter(function(dependent) {
        return __indexOf.call(dependent.cache.dependencies, path) >= 0;
      }).forEach(this._compile);
    };

    FileList.prototype._compile = function(file) {
      var _this = this;
      this.compiling.push(file);
      return file.compile(function(error) {
        _this.compiling.splice(_this.compiling.indexOf(file), 1);
        _this._resetTimer();
        if (error != null) {
          return;
        }
        logger.debug('info', "Compiled file '" + file.path + "'");
        return _this._compileDependentFiles(file.path);
      });
    };

    FileList.prototype._copy = function(asset) {
      var _this = this;
      this.copying.push(asset);
      return asset.copy(function(error) {
        _this.copying.splice(_this.copying.indexOf(asset), 1);
        _this._resetTimer();
        if (error != null) {
          return;
        }
        return logger.debug('info', "Copied asset '" + asset.path + "'");
      });
    };

    FileList.prototype._add = function(path, compiler, linters, isHelper) {
      var file, isVendor, wrapper;
      isVendor = this._isVendor(path);
      wrapper = this.config._normalized.modules.wrapper;
      file = new SourceFile(path, compiler, linters, wrapper, isHelper, isVendor);
      this.files.push(file);
      return file;
    };

    FileList.prototype._addAsset = function(path) {
      var file;
      file = new Asset(path, this.config);
      this.assets.push(file);
      return file;
    };

    FileList.prototype._change = function(path, compiler, linters, isHelper) {
      var ignored, _ref, _ref1;
      ignored = this._ignored(path);
      if (this._isAsset(path)) {
        if (!ignored) {
          return this._copy((_ref = this._findAssetByPath(path)) != null ? _ref : this._addAsset(path));
        }
      } else {
        if (ignored || !compiler) {
          return this._compileDependentFiles(path);
        } else {
          return this._compile((_ref1 = this._findByPath(path)) != null ? _ref1 : this._add(path, compiler, linters, isHelper));
        }
      }
    };

    FileList.prototype._unlink = function(path) {
      var file, ignored;
      ignored = this._ignored(path);
      if (this._isAsset(path)) {
        if (!ignored) {
          this.assets.splice(this.assets.indexOf(path), 1);
        }
      } else {
        if (ignored) {
          this._compileDependentFiles(path);
        } else {
          file = this._findByPath(path);
          this.files.splice(this.files.indexOf(file), 1);
        }
      }
      return this._resetTimer();
    };

    return FileList;

  })(EventEmitter);

}).call(this);
