// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var GeneratedFile, async, common, extractOrder, fs, helpers, inflection, loadTestFiles, logger, sort, sysPath,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  fs = require('fs');

  inflection = require('inflection');

  sysPath = require('path');

  async = require('async');

  common = require('./common');

  helpers = require('../helpers');

  logger = require('../logger');

  extractOrder = function(files, config) {
    var after, before, orders, types, vendorConvention;
    types = files.map(function(file) {
      return inflection.pluralize(file.type);
    });
    orders = Object.keys(config.files).filter(function(key) {
      return __indexOf.call(types, key) >= 0;
    }).map(function(key) {
      var _ref;
      return (_ref = config.files[key].order) != null ? _ref : {};
    });
    before = helpers.flatten(orders.map(function(type) {
      var _ref;
      return (_ref = type.before) != null ? _ref : [];
    }));
    after = helpers.flatten(orders.map(function(type) {
      var _ref;
      return (_ref = type.after) != null ? _ref : [];
    }));
    vendorConvention = config._normalized.conventions.vendor;
    return {
      before: before,
      after: after,
      vendorConvention: vendorConvention
    };
  };

  sort = function(files, config) {
    var indexes, order, paths;
    paths = files.map(function(file) {
      return file.path;
    });
    indexes = Object.create(null);
    files.forEach(function(file, index) {
      return indexes[file.path] = file;
    });
    order = extractOrder(files, config);
    return helpers.sortByConfig(paths, order).map(function(path) {
      return indexes[path];
    });
  };

  loadTestFiles = function(files, testsConvention) {
    return files.map(function(file) {
      return file.path;
    }).filter(function(path) {
      return testsConvention(path);
    }).map(function(path) {
      path = path.replace(RegExp('\\\\', 'g'), '/');
      return path.substring(0, path.lastIndexOf('.'));
    }).map(function(path) {
      return "window.require('" + path + "');";
    }).join('\n') + '\n';
  };

  module.exports = GeneratedFile = (function() {

    function GeneratedFile(path, sourceFiles, config, minifiers) {
      var _ref,
        _this = this;
      this.path = path;
      this.sourceFiles = sourceFiles;
      this.config = config;
      this.type = this.sourceFiles.some(function(file) {
        return file.type === 'javascript';
      }) ? 'javascript' : 'stylesheet';
      this.minifier = minifiers.filter(function(minifier) {
        return minifier.type === _this.type;
      })[0];
      this.isTestFile = (_ref = this.path, __indexOf.call(helpers.findTestFiles(this.config), _ref) >= 0);
      Object.freeze(this);
    }

    GeneratedFile.prototype._join = function(files, callback) {
      var joined, requireFiles,
        _this = this;
      logger.debug('writer', "Joining files '" + (files.map(function(file) {
        return file.path;
      }).join(', ')) + "' to '" + this.path + "'");
      requireFiles = function() {
        return loadTestFiles(files, _this.config._normalized.conventions.tests);
      };
      joined = files.map(function(file) {
        return file.cache.data;
      }).join('');
      return process.nextTick(function() {
        var data;
        if (_this.type === 'javascript') {
          data = _this.config._normalized.modules.definition(_this.path, joined) + joined;
          return callback(null, (_this.isTestFile ? data + requireFiles() : data));
        } else {
          return callback(null, joined);
        }
      });
    };

    GeneratedFile.prototype._minify = function(data, callback) {
      var _ref;
      if (this.config.minify && (((_ref = this.minifier) != null ? _ref.minify : void 0) != null)) {
        return this.minifier.minify(data, this.path, callback);
      } else {
        return callback(null, data);
      }
    };

    GeneratedFile.prototype.write = function(callback) {
      var _this = this;
      return this._join(sort(this.sourceFiles, this.config), function(error, joined) {
        if (error != null) {
          return callback(error);
        }
        return _this._minify(joined, function(error, data) {
          if (error != null) {
            return callback(error);
          }
          return common.writeFile(_this.path, data, callback);
        });
      });
    };

    return GeneratedFile;

  })();

}).call(this);
