// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var SourceFile, async, fs, logger, sysPath;

  async = require('async');

  fs = require('fs');

  sysPath = require('path');

  logger = require('../logger');

  module.exports = SourceFile = (function() {

    function SourceFile(path, compiler, linters, wrapper, isHelper, isVendor) {
      var fileName;
      this.path = path;
      this.compiler = compiler;
      this.linters = linters;
      this.wrapper = wrapper;
      this.isHelper = isHelper;
      this.isVendor = isVendor;
      logger.debug('info', "Initializing fs_utils.SourceFile:", {
        path: this.path,
        isHelper: this.isHelper,
        isVendor: this.isVendor
      });
      this.type = this.compiler.type;
      this.compilerName = this.compiler.constructor.name;
      if (isHelper) {
        fileName = "brunch_" + this.compilerName + "_" + (sysPath.basename(this.path));
        this.realPath = this.path;
        this.path = sysPath.join('vendor', 'scripts', fileName);
      }
      this.cache = Object.seal({
        data: '',
        dependencies: [],
        compilationTime: null,
        error: null
      });
      Object.freeze(this);
    }

    SourceFile.prototype._lint = function(data, path, callback) {
      var _this = this;
      if (this.linters.length === 0) {
        return callback(null);
      } else {
        return async.forEach(this.linters, function(linter, callback) {
          return linter.lint(data, path, callback);
        }, callback);
      }
    };

    SourceFile.prototype._getDependencies = function(data, path, callback) {
      if (this.compiler.getDependencies) {
        return this.compiler.getDependencies(data, path, callback);
      } else {
        return callback(null, []);
      }
    };

    SourceFile.prototype._wrap = function(data) {
      var moduleName, _ref, _ref1;
      if (!this.isHelper && !this.isVendor && ((_ref = this.type) === 'javascript' || _ref === 'template')) {
        moduleName = JSON.stringify(this.path.replace(new RegExp('\\\\', 'g'), '/').replace(/^app\//, '').replace(/\.\w+$/, ''));
        return this.wrapper(moduleName, data);
      } else {
        if ((_ref1 = this.type) === 'javascript' || _ref1 === 'template') {
          return "" + data + ";\n\n";
        } else {
          return data;
        }
      }
    };

    SourceFile.prototype.compile = function(callback) {
      var callbackError, realPath,
        _this = this;
      callbackError = function(type, stringOrError) {
        var error, string;
        string = stringOrError instanceof Error ? stringOrError.toString().slice(7) : stringOrError;
        error = new Error(string);
        error.brunchType = type;
        _this.cache.error = error;
        return callback(error);
      };
      realPath = this.isHelper ? this.realPath : this.path;
      return fs.readFile(realPath, function(error, buffer) {
        var fileContent;
        if (error != null) {
          return callbackError('Reading', error);
        }
        fileContent = buffer.toString();
        return _this._lint(fileContent, _this.path, function(error) {
          if (error != null) {
            return callbackError('Linting', error);
          }
          return _this.compiler.compile(fileContent, _this.path, function(error, result) {
            if (error != null) {
              return callbackError('Compiling', error);
            }
            return _this._getDependencies(fileContent, _this.path, function(error, dependencies) {
              if (error != null) {
                return callbackError('Dependency parsing', error);
              }
              _this.cache.dependencies = dependencies;
              if (result != null) {
                _this.cache.data = _this._wrap(result);
              }
              _this.cache.compilationTime = Date.now();
              _this.cache.error = null;
              return callback(null, _this.cache.data);
            });
          });
        });
      });
    };

    return SourceFile;

  })();

}).call(this);
