// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var GeneratedFile, async, changedSince, gatherErrors, getFiles, getPaths, helpers, inflection, sysPath, write;

  async = require('async');

  sysPath = require('path');

  inflection = require('inflection');

  GeneratedFile = require('./generated_file');

  helpers = require('../helpers');

  getPaths = function(sourceFile, joinConfig) {
    var sourceFileJoinConfig;
    sourceFileJoinConfig = joinConfig[inflection.pluralize(sourceFile.type)] || {};
    return Object.keys(sourceFileJoinConfig).filter(function(generatedFilePath) {
      var checker;
      checker = sourceFileJoinConfig[generatedFilePath];
      return checker(sourceFile.path);
    });
  };

  getFiles = function(fileList, config, joinConfig, minifiers) {
    var map;
    map = {};
    fileList.files.forEach(function(file) {
      var paths;
      paths = getPaths(file, joinConfig);
      return paths.forEach(function(path) {
        var _ref;
        if ((_ref = map[path]) == null) {
          map[path] = [];
        }
        return map[path].push(file);
      });
    });
    return Object.keys(map).map(function(generatedFilePath) {
      var fullPath, sourceFiles;
      sourceFiles = map[generatedFilePath];
      fullPath = sysPath.join(config.paths["public"], generatedFilePath);
      return new GeneratedFile(fullPath, sourceFiles, config, minifiers);
    });
  };

  changedSince = function(startTime) {
    return function(generatedFile) {
      return generatedFile.sourceFiles.some(function(sourceFile) {
        return sourceFile.cache.compilationTime >= startTime;
      });
    };
  };

  gatherErrors = function(generatedFiles) {
    var errors;
    errors = [];
    generatedFiles.forEach(function(generatedFile) {
      return generatedFile.sourceFiles.filter(function(sourceFile) {
        return sourceFile.cache.error != null;
      }).forEach(function(sourceFile) {
        var cache;
        cache = sourceFile.cache;
        return errors.push(helpers.formatError(cache.error, sourceFile.path));
      });
    });
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };

  module.exports = write = function(fileList, config, joinConfig, minifiers, startTime, callback) {
    var changed, error, files;
    files = getFiles(fileList, config, joinConfig, minifiers);
    changed = files.filter(changedSince(startTime));
    error = gatherErrors(files);
    if (error != null) {
      return callback(error);
    }
    return async.forEach(changed, (function(file, next) {
      return file.write(next);
    }), function(error) {
      if (error != null) {
        return callback(error);
      }
      return callback(null, changed);
    });
  };

}).call(this);
