// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var Handlebars, cachedTestFiles, callFunctionOrPass, coffeescript, createJoinConfig, deepFreeze, ensureArray, exec, express, extend, flatten, fs, getConfigDeprecations, getTestFiles, install, listToObj, logger, normalizeChecker, normalizeConfig, normalizeDefinition, normalizeWrapper, os, pwd, recursiveExtend, replaceSlashes, setConfigDefaults, sortAlphabetically, sortByAfter, sortByBefore, sortByVendor, startDefaultServer, startsWith, sysPath;

  exec = require('child_process').exec;

  coffeescript = require('coffee-script');

  express = require('express');

  Handlebars = require('handlebars');

  fs = require('fs');

  os = require('os');

  sysPath = require('path');

  logger = require('./logger');

  exports.startsWith = startsWith = function(string, substring) {
    return string.lastIndexOf(substring, 0) === 0;
  };

  exports.flatten = flatten = function(array) {
    return array.reduce(function(acc, elem) {
      return acc.concat(Array.isArray(elem) ? flatten(elem) : [elem]);
    }, []);
  };

  exports.callFunctionOrPass = callFunctionOrPass = function(thing) {
    if (typeof thing === 'function') {
      return thing();
    } else {
      return thing;
    }
  };

  exports.ensureArray = ensureArray = function(object) {
    if (Array.isArray(object)) {
      return object;
    } else {
      return [object];
    }
  };

  exports.extend = extend = function(object, properties) {
    Object.keys(properties).forEach(function(key) {
      return object[key] = properties[key];
    });
    return object;
  };

  recursiveExtend = function(object, properties) {
    Object.keys(properties).forEach(function(key) {
      var value;
      value = properties[key];
      if (typeof value === 'object' && (value != null)) {
        return recursiveExtend(object[key], value);
      } else {
        return object[key] = value;
      }
    });
    return object;
  };

  exports.deepFreeze = deepFreeze = function(object) {
    Object.keys(Object.freeze(object)).map(function(key) {
      return object[key];
    }).filter(function(value) {
      return typeof value === 'object' && (value != null) && !Object.isFrozen(value);
    }).forEach(deepFreeze);
    return object;
  };

  exports.formatError = function(error, path) {
    return "" + error.brunchType + " of '" + path + "' failed. " + (error.toString().slice(7));
  };

  sortAlphabetically = function(a, b) {
    if (a < b) {
      return -1;
    } else if (a > b) {
      return 1;
    } else {
      return 0;
    }
  };

  sortByVendor = function(config, a, b) {
    var aIsVendor, bIsVendor;
    aIsVendor = config.vendorConvention(a);
    bIsVendor = config.vendorConvention(b);
    if (aIsVendor && !bIsVendor) {
      return -1;
    } else if (!aIsVendor && bIsVendor) {
      return 1;
    } else {
      return sortAlphabetically(a, b);
    }
  };

  sortByAfter = function(config, a, b) {
    var hasA, hasB, indexOfA, indexOfB, _ref;
    indexOfA = config.after.indexOf(a);
    indexOfB = config.after.indexOf(b);
    _ref = [indexOfA !== -1, indexOfB !== -1], hasA = _ref[0], hasB = _ref[1];
    if (hasA && !hasB) {
      return 1;
    } else if (!hasA && hasB) {
      return -1;
    } else if (hasA && hasB) {
      return indexOfA - indexOfB;
    } else {
      return sortByVendor(config, a, b);
    }
  };

  sortByBefore = function(config, a, b) {
    var hasA, hasB, indexOfA, indexOfB, _ref;
    indexOfA = config.before.indexOf(a);
    indexOfB = config.before.indexOf(b);
    _ref = [indexOfA !== -1, indexOfB !== -1], hasA = _ref[0], hasB = _ref[1];
    if (hasA && !hasB) {
      return -1;
    } else if (!hasA && hasB) {
      return 1;
    } else if (hasA && hasB) {
      return indexOfA - indexOfB;
    } else {
      return sortByAfter(config, a, b);
    }
  };

  exports.sortByConfig = function(files, config) {
    var cfg, _ref, _ref1, _ref2;
    if (toString.call(config) === '[object Object]') {
      cfg = {
        before: (_ref = config.before) != null ? _ref : [],
        after: (_ref1 = config.after) != null ? _ref1 : [],
        vendorConvention: (_ref2 = config.vendorConvention) != null ? _ref2 : function() {
          return false;
        }
      };
      return files.slice().sort(function(a, b) {
        return sortByBefore(cfg, a, b);
      });
    } else {
      return files;
    }
  };

  exports.pwd = pwd = function() {
    return '.';
  };

  exports.install = install = function(rootPath, callback) {
    var prevDir;
    if (callback == null) {
      callback = (function() {});
    }
    prevDir = process.cwd();
    logger.info('Installing packages...');
    process.chdir(rootPath);
    return exec('npm install', function(error, stdout, stderr) {
      var log;
      process.chdir(prevDir);
      if (error != null) {
        log = stderr.toString();
        logger.error(log);
        return callback(log);
      }
      return callback(null, stdout);
    });
  };

  startDefaultServer = function(port, path, base, callback) {
    var server;
    server = express();
    server.use(function(request, response, next) {
      response.header('Cache-Control', 'no-cache');
      return next();
    });
    server.use(base, express["static"](path));
    server.all("" + base + "/*", function(request, response) {
      return response.sendfile(sysPath.join(path, 'index.html'));
    });
    server.listen(port, callback);
    return server;
  };

  exports.startServer = function(config, callback) {
    var onListening, port, publicPath, server;
    if (callback == null) {
      callback = (function() {});
    }
    port = parseInt(config.server.port, 10);
    publicPath = config.paths["public"];
    onListening = function() {
      logger.info("application started on http://localhost:" + port + "/");
      return callback();
    };
    if (config.server.path) {
      try {
        server = require(sysPath.resolve(config.server.path));
        return server.startServer(port, publicPath, onListening);
      } catch (error) {
        return logger.error("couldn\'t load server " + config.server.path + ": " + error);
      }
    } else {
      return startDefaultServer(port, publicPath, config.server.base, onListening);
    }
  };

  exports.replaceSlashes = replaceSlashes = function(config) {
    var changePath, files;
    changePath = function(string) {
      return string.replace(/\//g, '\\');
    };
    files = config.files || {};
    Object.keys(files).forEach(function(language) {
      var lang, newJoinTo, order;
      lang = files[language] || {};
      order = lang.order || {};
      Object.keys(order).forEach(function(orderKey) {
        return lang.order[orderKey] = lang.order[orderKey].map(changePath);
      });
      switch (toString.call(lang.joinTo)) {
        case '[object String]':
          return lang.joinTo = changePath(lang.joinTo);
        case '[object Object]':
          newJoinTo = {};
          Object.keys(lang.joinTo).forEach(function(joinToKey) {
            return newJoinTo[changePath(joinToKey)] = lang.joinTo[joinToKey];
          });
          return lang.joinTo = newJoinTo;
      }
    });
    return config;
  };

  normalizeChecker = function(item) {
    switch (toString.call(item)) {
      case '[object RegExp]':
        return function(string) {
          return item.test(string);
        };
      case '[object Function]':
        return item;
      default:
        throw new Error("Config item " + item + " is invalid.Use RegExp or Function.");
    }
  };

  listToObj = function(acc, elem) {
    acc[elem[0]] = elem[1];
    return acc;
  };

  createJoinConfig = function(configFiles) {
    var result, types;
    types = Object.keys(configFiles);
    result = types.map(function(type) {
      return configFiles[type].joinTo;
    }).map(function(joinTo) {
      var object;
      if (typeof joinTo === 'string') {
        object = {};
        object[joinTo] = /.+/;
        return object;
      } else {
        return joinTo;
      }
    }).map(function(joinTo, index) {
      var makeChecker, subConfig;
      makeChecker = function(generatedFilePath) {
        return [generatedFilePath, normalizeChecker(joinTo[generatedFilePath])];
      };
      subConfig = Object.keys(joinTo).map(makeChecker).reduce(listToObj, {});
      return [types[index], subConfig];
    }).reduce(listToObj, {});
    return Object.freeze(result);
  };

  normalizeWrapper = function(typeOrFunction) {
    switch (typeOrFunction) {
      case 'commonjs':
        return function(path, data) {
          return "window.require.define({" + path + ": function(exports, require, module) {\n  " + (data.replace(/\n(?!\n)/g, '\n  ')) + "\n}});\n\n";
        };
      case 'amd':
        return function(path, data) {
          return "define(" + path + ", ['require', 'exports', 'module'], function(require, exports, module) {\n  " + (data.replace(/\n(?!\n)/g, '\n  ')) + "\n});";
        };
      case false:
        return function(path, data) {
          return "" + data;
        };
      default:
        if (typeof typeOrFunction === 'function') {
          return typeOrFunction;
        } else {
          throw new Error('config.modules.wrapper should be a function or one of:\
"commonjs", "amd", false');
        }
    }
  };

  normalizeDefinition = function(typeOrFunction) {
    var data, path;
    switch (typeOrFunction) {
      case 'commonjs':
        path = sysPath.join(__dirname, '..', 'vendor', 'require_definition.js');
        data = fs.readFileSync(path).toString();
        return function() {
          return data;
        };
      case 'amd':
      case false:
        return function() {
          return '';
        };
      default:
        if (typeof typeOrFunction === 'function') {
          return typeOrFunction;
        } else {
          throw new Error('config.modules.definition should be a function\
or one of: "commonjs", false');
        }
    }
  };

  exports.setConfigDefaults = setConfigDefaults = function(config, configPath) {
    var conventions, join, joinRoot, modules, paths, _base, _base1, _base2, _ref, _ref1, _ref10, _ref11, _ref12, _ref13, _ref14, _ref15, _ref16, _ref17, _ref18, _ref19, _ref2, _ref20, _ref21, _ref22, _ref23, _ref24, _ref3, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9,
      _this = this;
    join = function(parent, name) {
      return sysPath.join(config.paths[parent], name);
    };
    joinRoot = function(name) {
      return join('root', name);
    };
    paths = (_ref = config.paths) != null ? _ref : config.paths = {};
    if ((_ref1 = paths.root) == null) {
      paths.root = (_ref2 = config.rootPath) != null ? _ref2 : pwd();
    }
    if ((_ref3 = paths["public"]) == null) {
      paths["public"] = (_ref4 = config.buildPath) != null ? _ref4 : joinRoot('public');
    }
    if ((_ref5 = paths.app) == null) {
      paths.app = joinRoot('app');
    }
    if ((_ref6 = paths.generators) == null) {
      paths.generators = joinRoot('generators');
    }
    if ((_ref7 = paths.test) == null) {
      paths.test = joinRoot('test');
    }
    if ((_ref8 = paths.vendor) == null) {
      paths.vendor = joinRoot('vendor');
    }
    if ((_ref9 = paths.assets) == null) {
      paths.assets = join('app', 'assets');
    }
    paths.config = configPath != null ? configPath : joinRoot('config');
    if ((_ref10 = paths.packageConfig) == null) {
      paths.packageConfig = joinRoot('package.json');
    }
    conventions = (_ref11 = config.conventions) != null ? _ref11 : config.conventions = {};
    if ((_ref12 = conventions.assets) == null) {
      conventions.assets = /assets(\/|\\)/;
    }
    if ((_ref13 = conventions.ignored) == null) {
      conventions.ignored = (_ref14 = paths.ignored) != null ? _ref14 : function(path) {
        return startsWith(sysPath.basename(path), '_');
      };
    }
    if ((_ref15 = conventions.tests) == null) {
      conventions.tests = /_test\.\w+$/;
    }
    if ((_ref16 = conventions.vendor) == null) {
      conventions.vendor = /vendor(\/|\\)/;
    }
    if ((_ref17 = config.notifications) == null) {
      config.notifications = true;
    }
    modules = (_ref18 = config.modules) != null ? _ref18 : config.modules = {};
    if ((_ref19 = modules.wrapper) == null) {
      modules.wrapper = 'commonjs';
    }
    if ((_ref20 = modules.definition) == null) {
      modules.definition = 'commonjs';
    }
    if ((_ref21 = config.server) == null) {
      config.server = {};
    }
    if ((_ref22 = (_base = config.server).base) == null) {
      _base.base = '';
    }
    if ((_ref23 = (_base1 = config.server).port) == null) {
      _base1.port = 3333;
    }
    if ((_ref24 = (_base2 = config.server).run) == null) {
      _base2.run = false;
    }
    return config;
  };

  getConfigDeprecations = function(config) {
    var ensureNotArray, messages, warnMoved;
    messages = [];
    warnMoved = function(configItem, from, to) {
      if (configItem) {
        return messages.push("config." + from + " moved to config." + to);
      }
    };
    warnMoved(config.paths.ignored, 'paths.ignored', 'conventions.ignored');
    warnMoved(config.rootPath, 'rootPath', 'paths.root');
    warnMoved(config.buildPath, 'buildPath', 'paths.public');
    ensureNotArray = function(name) {
      if (Array.isArray(config.paths[name])) {
        return messages.push("config.paths." + name + " can't be an array.Use config.conventions." + name);
      }
    };
    ensureNotArray('assets');
    ensureNotArray('test');
    ensureNotArray('vendor');
    return messages;
  };

  normalizeConfig = function(config) {
    var normalized;
    normalized = {};
    normalized.join = createJoinConfig(config.files);
    normalized.modules = {};
    normalized.modules.wrapper = normalizeWrapper(config.modules.wrapper);
    normalized.modules.definition = normalizeDefinition(config.modules.definition);
    normalized.conventions = {};
    Object.keys(config.conventions).forEach(function(name) {
      return normalized.conventions[name] = normalizeChecker(config.conventions[name]);
    });
    config._normalized = Object.freeze(normalized);
    return config;
  };

  exports.loadConfig = function(configPath, options) {
    var config, deprecations, fullPath;
    if (configPath == null) {
      configPath = 'config';
    }
    if (options == null) {
      options = {};
    }
    fullPath = sysPath.resolve(configPath);
    delete require.cache[fullPath];
    try {
      config = require(fullPath).config;
    } catch (error) {
      throw new Error("couldn\'t load config " + configPath + ". " + error);
    }
    setConfigDefaults(config, fullPath);
    deprecations = getConfigDeprecations(config);
    if (deprecations.length > 0) {
      deprecations.forEach(logger.warn);
    }
    recursiveExtend(config, options);
    if (os.platform() === 'win32') {
      replaceSlashes(config);
    }
    normalizeConfig(config);
    deepFreeze(config);
    return config;
  };

  exports.loadPackages = function(rootPath, callback) {
    var nodeModules;
    rootPath = sysPath.resolve(rootPath);
    nodeModules = "" + rootPath + "/node_modules";
    return fs.readFile(sysPath.join(rootPath, 'package.json'), function(error, data) {
      var deps, json, plugins, _ref;
      if (error != null) {
        return callback(error);
      }
      json = JSON.parse(data);
      deps = Object.keys(extend((_ref = json.devDependencies) != null ? _ref : {}, json.dependencies));
      try {
        plugins = deps.map(function(dependency) {
          return require("" + nodeModules + "/" + dependency);
        });
      } catch (err) {
        error = err;
      }
      return callback(error, plugins);
    });
  };

  exports.getPlugins = function(packages, config) {
    return packages.filter(function(plugin) {
      return (plugin.prototype != null) && plugin.prototype.brunchPlugin;
    }).map(function(plugin) {
      return new plugin(config);
    });
  };

  getTestFiles = function(config) {
    var files, isTestFile, joinPublic, joinTo;
    isTestFile = function(generatedFile) {
      return exports.startsWith(generatedFile, sysPath.normalize('test/')) && generatedFile.lastIndexOf('vendor') === -1;
    };
    joinPublic = function(generatedFile) {
      return sysPath.join(config.paths["public"], generatedFile);
    };
    joinTo = config.files.javascripts.joinTo;
    files = typeof joinTo === 'string' ? [joinTo] : Object.keys(joinTo);
    return files.filter(isTestFile).map(joinPublic);
  };

  cachedTestFiles = null;

  exports.findTestFiles = function(config) {
    return cachedTestFiles != null ? cachedTestFiles : cachedTestFiles = getTestFiles(config);
  };

  Handlebars.registerHelper('camelize', (function() {
    var camelize;
    camelize = function(string) {
      var regexp, rest;
      regexp = /[-_]([a-z])/g;
      rest = string.replace(regexp, function(match, char) {
        return char.toUpperCase();
      });
      return rest[0].toUpperCase() + rest.slice(1);
    };
    return function(options) {
      return new Handlebars.SafeString(camelize(options.fn(this)));
    };
  })());

  exports.formatTemplate = function(template, templateData) {
    var compiled, key;
    key = '__BRUNCH_TEMPLATE_FORMATTER';
    compiled = Handlebars.compile(template.replace(/\\\{/, key));
    return compiled(templateData).toString().replace(key, '\\');
  };

}).call(this);
