// Generated by CoffeeScript 1.3.3
(function() {
  'use strict';

  var color, colors, getInfo, growl, logger, namespace,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
    __slice = [].slice;

  color = require('ansi-color');

  growl = require('growl');

  require('date-utils');

  colors = {
    error: 'red',
    warn: 'yellow',
    info: 'green',
    debug: 'blue'
  };

  getInfo = function(level) {
    var date, lvl;
    date = new Date().toFormat('DD MMM HH24:MI:SS');
    lvl = color.set(level, colors[level]);
    return "" + date + " - " + lvl + ":";
  };

  namespace = process.env.BRUNCH_DEBUG;

  logger = {
    isDebug: Boolean(namespace),
    errorHappened: false,
    notifications: true,
    debugNamespace: (function() {
      if (namespace) {
        if (namespace === '*') {
          return '*';
        } else {
          return namespace.split(',');
        }
      } else {
        return [];
      }
    })(),
    matchesDebugNamespace: function(current) {
      namespace = logger.debugNamespace;
      return namespace === '*' || __indexOf.call(namespace, current) >= 0;
    },
    log: function() {
      var args, info, level;
      level = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      info = getInfo(level);
      return process.nextTick(function() {
        if (level === 'error' || level === 'warn') {
          return console.error.apply(console, [info].concat(__slice.call(args)));
        } else {
          return console.log.apply(console, [info].concat(__slice.call(args)));
        }
      });
    },
    error: function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (logger.notifications) {
        growl(args.join(' '), {
          title: 'Brunch error'
        });
      }
      logger.errorHappened = true;
      return logger.log.apply(logger, ['error'].concat(__slice.call(args)));
    },
    warn: function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return logger.log.apply(logger, ['warn'].concat(__slice.call(args)));
    },
    info: function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return logger.log.apply(logger, ['info'].concat(__slice.call(args)));
    },
    debug: function() {
      var args, namespace;
      namespace = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      if (logger.isDebug && logger.matchesDebugNamespace(namespace)) {
        return logger.log.apply(logger, ['debug'].concat(__slice.call(args)));
      }
    }
  };

  module.exports = Object.seal(logger);

}).call(this);
