// Generated by CoffeeScript 1.3.3
(function() {
  var CoffeeScriptCompiler, capitalize, coffeescript, formatClassName;

  coffeescript = require('coffee-script');

  capitalize = function(string) {
    return (string[0] || '').toUpperCase() + string.slice(1);
  };

  formatClassName = function(filename) {
    return filename.split('_').map(capitalize).join('');
  };

  module.exports = CoffeeScriptCompiler = (function() {

    CoffeeScriptCompiler.prototype.brunchPlugin = true;

    CoffeeScriptCompiler.prototype.type = 'javascript';

    CoffeeScriptCompiler.prototype.extension = 'coffee';

    CoffeeScriptCompiler.prototype.generators = {
      backbone: {
        model: function(name, pluralName) {
          return "module.exports = class " + (formatClassName(name)) + " extends Backbone.Model\n";
        },
        view: function(name, pluralName) {
          return "template = require 'views/templates/" + name + "'\n\nmodule.exports = class " + (formatClassName(name)) + "View extends Backbone.View\n  template: template\n";
        }
      },
      chaplin: {
        controller: function(name, pluralName) {
          return "Controller = require 'controllers/base/controller'\n\nmodule.exports = class " + (formatClassName(pluralName)) + "Controller extends Controller\n";
        },
        collection: function(name, pluralName) {
          return "Collection = require 'models/base/collection'\n" + (formatClassName(name)) + " = require 'models/" + name + "'\n\nmodule.exports = class " + (formatClassName(pluralName)) + " extends Collection\n  model: " + (formatClassName(name)) + "\n";
        },
        model: function(name, pluralName) {
          return "Model = require 'models/base/model'\n\nmodule.exports = class " + (formatClassName(name)) + " extends Model\n";
        },
        view: function(name, pluralName) {
          return "View = require 'views/base/view'\ntemplate = require 'views/templates/" + name + "'\n\nmodule.exports = class " + (formatClassName(name)) + "View extends View\n  template: template\n";
        },
        'page-view': function(name, pluralName) {
          return "PageView = require 'views/base/page_view'\ntemplate = require 'views/templates/" + name + "_page'\n\nmodule.exports = class " + (formatClassName(name)) + "PageView extends View\n  template: template\n";
        },
        'collection-view': function(name, pluralName) {
          return "CollectionView = require 'views/base/collection_view'\n" + (formatClassName(name)) + " = require 'views/" + name + "_view'\n\nmodule.exports = class " + (formatClassName(pluralName)) + "View extends CollectionView\n  getView: (item) ->\n    new " + (formatClassName(name)) + " model: item\n";
        }
      }
    };

    function CoffeeScriptCompiler(config) {
      this.config = config;
      null;
    }

    CoffeeScriptCompiler.prototype.compile = function(data, path, callback) {
      var error, result;
      try {
        return result = coffeescript.compile(data, {
          bare: true
        });
      } catch (err) {
        return error = err;
      } finally {
        callback(error, result);
      }
    };

    return CoffeeScriptCompiler;

  })();

}).call(this);
