// Generated by CoffeeScript 1.3.3
(function() {
  var StylusCompiler, nib, stylus, sysPath,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  nib = require('nib');

  stylus = require('stylus');

  sysPath = require('path');

  module.exports = StylusCompiler = (function() {

    StylusCompiler.prototype.brunchPlugin = true;

    StylusCompiler.prototype.type = 'stylesheet';

    StylusCompiler.prototype.extension = 'styl';

    StylusCompiler.prototype._dependencyRegExp = /^ *@import ['"](.*)['"]/;

    function StylusCompiler(config) {
      this.config = config;
      this.getDependencies = __bind(this.getDependencies, this);

      this.compile = __bind(this.compile, this);

      null;
    }

    StylusCompiler.prototype.compile = function(data, path, callback) {
      var compiler, defines, _ref, _ref1, _ref2;
      compiler = stylus(data).set('compress', false).set('firebug', !!((_ref = this.config.stylus) != null ? _ref.firebug : void 0)).include(sysPath.join(this.config.paths.root)).include(sysPath.dirname(path)).use(nib());
      if (this.config.stylus) {
        defines = (_ref1 = this.config.stylus.defines) != null ? _ref1 : {};
        Object.keys(defines).forEach(function(name) {
          return compiler.define(name, defines[name]);
        });
        if ((_ref2 = this.config.stylus.paths) != null) {
          _ref2.forEach(function(path) {
            return compiler.include(path);
          });
        }
      }
      return compiler.render(callback);
    };

    StylusCompiler.prototype.getDependencies = function(data, path, callback) {
      var dependencies, parent,
        _this = this;
      parent = sysPath.dirname(path);
      dependencies = data.split('\n').map(function(line) {
        return line.match(_this._dependencyRegExp);
      }).filter(function(match) {
        return (match != null ? match.length : void 0) > 0;
      }).map(function(match) {
        return match[1];
      }).filter(function(path) {
        return !!path && path !== 'nib';
      }).map(function(path) {
        if (sysPath.extname(path) !== ("." + _this.extension)) {
          return path + ("." + _this.extension);
        } else {
          return path;
        }
      }).map(function(path) {
        if (path.charAt(0) === '/') {
          return sysPath.join(_this.config.paths.root, path.slice(1));
        } else {
          return sysPath.join(parent, path);
        }
      });
      return process.nextTick(function() {
        return callback(null, dependencies);
      });
    };

    return StylusCompiler;

  })();

}).call(this);
