/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.npm;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.mule.tools.npm.DownloadCountingOutputStream;
import org.mule.tools.npm.ProgressListener;

public class NPMModule {
    private static String NPM_URL = "http://registry.npmjs.org/%s/%s";
    private String name;
    public String version;
    private Log log;
    private List<NPMModule> dependencies;
    private URL downloadURL;

    public String getName() {
        return this.name;
    }

    public String getVerion() {
        return this.version;
    }

    public List<NPMModule> getDependencies() {
        return this.dependencies;
    }

    public void saveToFileWithDependencies(File file) throws MojoExecutionException {
        this.saveToFile(file);
        for (NPMModule dependency : this.dependencies) {
            dependency.saveToFileWithDependencies(file);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(File file) throws MojoExecutionException {
        File fileToMove;
        FileOutputStream os = null;
        InputStream is = null;
        File outputFolderFileTmp = new File(file, this.name + "_tmp");
        File outputFolderFile = new File(file, this.name);
        if (outputFolderFile.exists()) {
            return;
        }
        outputFolderFileTmp.mkdirs();
        File tarFile = new File(outputFolderFileTmp, this.name + "-" + this.version + ".tgz");
        ProgressListener progressListener = new ProgressListener(this.log);
        try {
            os = new FileOutputStream(tarFile);
            is = this.getDownloadURL().openStream();
            DownloadCountingOutputStream dcount = new DownloadCountingOutputStream(os);
            dcount.setListener(progressListener);
            this.getDownloadURL().openConnection().getHeaderField("Content-Length");
            IOUtils.copy((InputStream)is, (OutputStream)((Object)dcount));
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException(String.format("Error downloading module %s:%s", this.name, this.version), (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException(String.format("Error downloading module %s:%s", this.name, this.version), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        TarGZipUnArchiver ua = new TarGZipUnArchiver();
        ua.enableLogging((Logger)new LoggerAdapter(this.log));
        ua.setSourceFile(tarFile);
        ua.setDestDirectory(outputFolderFileTmp);
        ua.extract();
        FileUtils.deleteQuietly((File)tarFile);
        File[] files = outputFolderFileTmp.listFiles();
        if (files != null && files.length == 1) {
            fileToMove = files[0];
        } else {
            File aPackage = new File(outputFolderFileTmp, "package");
            if (aPackage.exists() && aPackage.isDirectory()) {
                fileToMove = aPackage;
            } else {
                throw new MojoExecutionException(String.format("Only one file should be present at the folder when unpacking module %s:%s: ", this.name, this.version));
            }
        }
        try {
            FileUtils.moveDirectory((File)fileToMove, (File)outputFolderFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error moving to the final folder when unpacking module %s:%s: ", this.name, this.version), (Exception)e);
        }
        try {
            FileUtils.deleteDirectory((File)outputFolderFileTmp);
            return;
        }
        catch (IOException e) {
            this.log.info((CharSequence)("Error while deleting temporary folder: " + outputFolderFileTmp), (Throwable)e);
        }
    }

    private void downloadDependencies(Map dependenciesMap) throws IOException, MojoExecutionException {
        Iterator i$ = dependenciesMap.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry dependencyAsObject;
            Map.Entry dependency = dependencyAsObject = i$.next();
            String dependencyName = (String)dependency.getKey();
            String version = (String)dependency.getValue();
            int i = version.lastIndexOf(" ");
            if (i != -1) {
                version = version.substring(i + 1);
            }
            if ((i = version.lastIndexOf("~")) != -1) {
                version = version.substring(i + 1);
            }
            if ((i = version.lastIndexOf("x")) != -1) {
                version = version.substring(0, i);
            }
            try {
                this.dependencies.add(NPMModule.fromNameAndVersion(this.log, dependencyName, version));
            }
            catch (MojoExecutionException e) {
                for (Object o : this.downloadMetadataList(dependencyName)) {
                    String dependencyVersion = (String)o;
                    if (!dependencyVersion.startsWith(version)) continue;
                    this.dependencies.add(NPMModule.fromNameAndVersion(this.log, dependencyName, dependencyVersion));
                    return;
                }
                throw new RuntimeException("Error resolving dependency: " + dependencyName + ":" + version + " not found.");
            }
        }
    }

    private Set downloadMetadataList(String name) throws IOException, JsonParseException {
        URL dl = new URL(String.format(NPM_URL, name, ""));
        ObjectMapper objectMapper = new ObjectMapper();
        Map allVersionsMetadata = (Map)objectMapper.readValue(dl, Map.class);
        return ((Map)allVersionsMetadata.get("versions")).keySet();
    }

    private Map downloadMetadata(String name, String version) throws IOException, JsonParseException {
        URL dl = new URL(String.format(NPM_URL, name, version != null ? version : "latest"));
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(dl, Map.class);
    }

    private void downloadModule() throws MojoExecutionException {
        try {
            Map jsonMap = this.downloadMetadata(this.name, this.version);
            Map distMap = (Map)jsonMap.get("dist");
            this.downloadURL = new URL((String)distMap.get("tarball"));
            this.version = (String)jsonMap.get("version");
            Map dependenciesMap = (Map)jsonMap.get("dependencies");
            if (dependenciesMap != null) {
                this.downloadDependencies(dependenciesMap);
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(String.format("Error downloading module info %s:%s", this.name, this.version), (Exception)e);
        }
        catch (JsonMappingException e) {
            throw new MojoExecutionException(String.format("Error downloading module info %s:%s", this.name, this.version), (Exception)((Object)e));
        }
        catch (JsonParseException e) {
            throw new MojoExecutionException(String.format("Error downloading module info %s:%s", this.name, this.version), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Error downloading module info %s:%s", this.name, this.version), (Exception)e);
        }
    }

    private NPMModule() {
    }

    public static NPMModule fromQueryString(Log log, String nameAndVersion) throws MojoExecutionException {
        String[] splitNameAndVersion = nameAndVersion.split(":");
        return NPMModule.fromNameAndVersion(log, splitNameAndVersion[0], splitNameAndVersion[1]);
    }

    public static NPMModule fromNameAndVersion(Log log, String name, String version) throws MojoExecutionException {
        NPMModule module = new NPMModule();
        module.log = log;
        module.name = name;
        module.version = version;
        module.dependencies = new ArrayList<NPMModule>();
        module.downloadModule();
        return module;
    }

    public URL getDownloadURL() {
        return this.downloadURL;
    }

    public static NPMModule fromName(Log log, String name) throws MojoExecutionException {
        return NPMModule.fromNameAndVersion(log, name, null);
    }

    private static class LoggerAdapter
    implements Logger {
        private Log log;
        private int threshold;

        public LoggerAdapter(Log log) {
            this.log = log;
        }

        public void debug(String message) {
            this.log.debug((CharSequence)message);
        }

        public void debug(String message, Throwable throwable) {
            this.log.debug((CharSequence)message, throwable);
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void info(String message) {
            this.log.info((CharSequence)message);
        }

        public void info(String message, Throwable throwable) {
            this.log.info((CharSequence)message, throwable);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void warn(String message) {
            this.log.warn((CharSequence)message);
        }

        public void warn(String message, Throwable throwable) {
            this.log.warn((CharSequence)message, throwable);
        }

        public boolean isWarnEnabled() {
            return this.log.isWarnEnabled();
        }

        public void error(String message) {
            this.log.error((CharSequence)message);
        }

        public void error(String message, Throwable throwable) {
            this.log.error((CharSequence)message, throwable);
        }

        public boolean isErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        public void fatalError(String message) {
            this.log.error((CharSequence)message);
        }

        public void fatalError(String message, Throwable throwable) {
            this.log.error((CharSequence)message, throwable);
        }

        public boolean isFatalErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        public int getThreshold() {
            return this.threshold;
        }

        public void setThreshold(int threshold) {
            this.threshold = threshold;
        }

        public Logger getChildLogger(String name) {
            return null;
        }

        public String getName() {
            return null;
        }
    }
}

