/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.rhinodo.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Queue;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mule.tools.rhinodo.api.ConsoleFactory;
import org.mule.tools.rhinodo.api.NodeModuleFactory;
import org.mule.tools.rhinodo.api.Runnable;
import org.mule.tools.rhinodo.impl.NodeModuleFactoryImpl;
import org.mule.tools.rhinodo.impl.PrimitiveNodeModuleFactory;
import org.mule.tools.rhinodo.impl.SystemOutConsole;
import org.mule.tools.rhinodo.impl.WrappingConsoleFactory;
import org.mule.tools.rhinodo.rhino.NodeJsGlobal;
import org.mule.tools.rhinodo.rhino.NodeRequireBuilder;

public class JavascriptRunner {
    private URI env;
    private NodeModuleFactory nodeModuleFactory;
    private Runnable runnable;
    private final Queue<Function> asyncFunctionQueue = new LinkedList<Function>();
    private ConsoleFactory consoleFactory;
    private Scriptable console;

    public Scriptable getConsole() {
        return this.console;
    }

    public static JavascriptRunner withConsoleFactory(ConsoleFactory consoleFactory, NodeModuleFactoryImpl nodeModuleFactory, Runnable runnable, String destDir) {
        JavascriptRunner javascriptRunner = new JavascriptRunner(nodeModuleFactory, runnable, destDir);
        javascriptRunner.consoleFactory = consoleFactory;
        return javascriptRunner;
    }

    public JavascriptRunner(NodeModuleFactoryImpl nodeModuleFactory, Runnable runnable, String destDir) {
        this.env = JavascriptRunner.getURIFromResources(this.getClass(), "META-INF/env");
        this.nodeModuleFactory = new PrimitiveNodeModuleFactory(this.env, nodeModuleFactory, destDir);
        this.runnable = runnable;
        this.consoleFactory = new WrappingConsoleFactory(new SystemOutConsole());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NodeJsGlobal global = new NodeJsGlobal();
        Context ctx = Context.enter();
        ctx.setOptimizationLevel(9);
        ctx.setLanguageVersion(170);
        global.initStandardObjects(ctx, false);
        try {
            Function asyncToExecute;
            global.installNodeJsRequire(ctx, this.nodeModuleFactory, new NodeRequireBuilder(this.asyncFunctionQueue), false);
            this.addConsole(global);
            NativeObject process = new NativeObject();
            process.put("platform", (Scriptable)process, (Object)Context.toString((Object)"darwin"));
            process.put("env", (Scriptable)process, (Object)new NativeObject());
            global.put("process", (Scriptable)global, process);
            this.runnable.executeJavascript(ctx, global);
            while ((asyncToExecute = this.asyncFunctionQueue.poll()) != null) {
                asyncToExecute.call(ctx, (Scriptable)global, (Scriptable)global, new Object[0]);
            }
        }
        finally {
            Context.exit();
        }
    }

    private void addConsole(NodeJsGlobal global) {
        this.console = this.consoleFactory.getConsoleAsScriptable();
        global.put("console", (Scriptable)global, this.console);
    }

    public static URI getURIFromResources(Class<?> klass, String path) {
        ClassLoader classLoader = klass.getClassLoader();
        URL root = classLoader.getResource(path);
        if (root == null) {
            throw new IllegalStateException("root cannot be null");
        }
        try {
            return root.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

