/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.rhinodo.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.tools.rhinodo.api.NodeModule;
import org.mule.tools.rhinodo.tools.JarURIHelper;

public class NodeModuleImpl
implements NodeModule {
    private URI path;
    private String name;

    public static NodeModuleImpl fromJar(Class<?> klass, String rootDirectory, String destDir) {
        JarURIHelper jarURIHelper;
        if (rootDirectory == null) {
            throw new IllegalArgumentException("Error validating rootDirectory");
        }
        if (destDir == null) {
            throw new IllegalArgumentException("Error validating destDir");
        }
        URI root = NodeModuleImpl.getRoot(klass, rootDirectory);
        if (!"jar".equals(root.getScheme())) {
            throw new IllegalArgumentException("URI must have jar scheme");
        }
        new File(destDir).mkdirs();
        try {
            jarURIHelper = new JarURIHelper(root);
            jarURIHelper.copyToFolder(destDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NodeModuleImpl(klass, destDir + File.separator + jarURIHelper.getInsideJarRelativePath());
    }

    private NodeModuleImpl(Class<?> klass, String rootDirectory) {
        Map map;
        URI packageJson;
        if (rootDirectory == null) {
            throw new IllegalArgumentException("Error validating rootDirectory");
        }
        URI root = new File(rootDirectory + "/").toURI();
        try {
            packageJson = new URI(root.toString() + "package.json");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!"file".equals(packageJson.getScheme())) {
            if ("jar".equals(packageJson.getScheme())) {
                throw new RuntimeException("jar scheme not supported");
            }
            throw new IllegalStateException(String.format("Error: scheme [%s] not supported.", packageJson.getScheme()));
        }
        boolean exists = new File(packageJson).exists();
        if (!exists) {
            throw new IllegalStateException(String.format("Error: package.json not found at [%s].", packageJson));
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            InputStream inputStream = packageJson.toURL().openStream();
            map = (Map)objectMapper.readValue(inputStream, Map.class);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error: trying to parse package.json.");
        }
        String main1 = (String)map.get("main");
        if (main1.startsWith("./")) {
            main1 = main1.substring(2);
        }
        try {
            this.path = new URI(root.toString() + main1);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.name = (String)map.get("name");
    }

    private static URI getRoot(Class<?> klass, String rootDirectory) {
        URI root;
        ClassLoader classLoader = klass.getClassLoader();
        try {
            root = classLoader.getResource(rootDirectory).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (root == null) {
            throw new IllegalStateException("Error: path not found.");
        }
        try {
            root = new URI(root.toString() + "/");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return root;
    }

    public NodeModuleImpl(String moduleName, URI path) {
        this.name = moduleName;
        this.path = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeModuleImpl that = (NodeModuleImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

