/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.rhinodo.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mule.tools.rhinodo.api.Console;
import org.mule.tools.rhinodo.api.ConsoleFactory;
import org.mule.tools.rhinodo.impl.LogFunctionWrapper;

public class WrappingConsoleFactory
implements ConsoleFactory {
    private Console console;
    Map<String, LogFunctionWrapper> functionWrapperMap = new HashMap<String, LogFunctionWrapper>();

    public WrappingConsoleFactory(Console console) {
        this.console = console;
        for (Method method : Console.class.getDeclaredMethods()) {
            this.functionWrapperMap.put(method.getName(), LogFunctionWrapper.fromMethodWithDebugging(console, method));
        }
    }

    @Override
    public Scriptable getConsoleAsScriptable() {
        NativeObject consoleNativeObject = new NativeObject();
        for (Map.Entry<String, LogFunctionWrapper> stringFunctionWrapperEntry : this.functionWrapperMap.entrySet()) {
            consoleNativeObject.put(stringFunctionWrapperEntry.getKey(), (Scriptable)consoleNativeObject, (Object)stringFunctionWrapperEntry.getValue());
        }
        return consoleNativeObject;
    }
}

