/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.rhinodo.rhino;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.jar.JarEntry;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mule.tools.rhinodo.tools.JarURIHelper;

public class NodeJsUrlModuleSourceProvider
extends UrlModuleSourceProvider {
    private Map<String, URI> privilegedUris;

    public NodeJsUrlModuleSourceProvider(Map<String, URI> privilegedUris) {
        super(privilegedUris.values(), null);
        this.privilegedUris = privilegedUris;
    }

    protected ModuleSource loadFromPrivilegedLocations(String moduleId, Object validator) throws IOException, URISyntaxException {
        return this.loadFromPathMap(moduleId, validator, this.privilegedUris);
    }

    protected ModuleSource loadFromUri(URI uri, URI base, Object validator) throws IOException, URISyntaxException {
        String s = uri.toString();
        if (s.lastIndexOf("/") == s.length() - 1) {
            s = s.substring(0, s.lastIndexOf("/", s.length() - 1));
        }
        if (!s.startsWith(base.toString()) && !s.startsWith("./")) {
            if (s.lastIndexOf("/") != -1) {
                base = new URI(s.substring(0, s.lastIndexOf("/")));
            }
        } else if (uri.toString().startsWith("./")) {
            uri = URI.create(base.toString() + uri.toString().substring(2));
            System.out.println("relative uri:" + uri.toString());
        }
        return super.loadFromUri(uri, base, validator);
    }

    private ModuleSource loadFromPathMap(String moduleId, Object validator, Map<String, URI> paths) throws IOException, URISyntaxException {
        URI newBasePath;
        ModuleSource moduleSource;
        URI path;
        if (paths == null) {
            return null;
        }
        URI basePath = paths.get(moduleId);
        if (basePath == null) {
            return super.loadFromPrivilegedLocations(moduleId, validator);
        }
        if ("file".equals(basePath.getScheme())) {
            path = this.getModuleRealURIWithFileScheme(basePath);
        } else if ("jar".equals(basePath.getScheme())) {
            path = this.getModuleRealURIWithJarScheme(basePath);
        } else {
            throw new RuntimeException(String.format("Module loading [%s] scheme not supported.", basePath.getScheme()));
        }
        String pathAsString = path.toString();
        int lastIndex = 0;
        lastIndex = pathAsString.lastIndexOf("/");
        if (lastIndex == pathAsString.length() - 1) {
            lastIndex = pathAsString.lastIndexOf("/", pathAsString.lastIndexOf("/") - 1);
        }
        if ((moduleSource = this.loadFromUri(path, newBasePath = URI.create(pathAsString.substring(0, lastIndex + 1)), validator)) != null) {
            return moduleSource;
        }
        return null;
    }

    private URI getModuleRealURIWithJarScheme(URI basePath) {
        String substring;
        String insideJarRelativePath;
        JarURIHelper jarHelper = new JarURIHelper(basePath);
        Map<String, JarEntry> entryList = jarHelper.getEntryList();
        URI uri = this.resolverFile(basePath, entryList, insideJarRelativePath = jarHelper.getInsideJarRelativePath(), substring = insideJarRelativePath.substring(0, insideJarRelativePath.length() - 1));
        if (uri == null) {
            uri = this.resolverFile(basePath, entryList, insideJarRelativePath, insideJarRelativePath);
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Error: invalid jar path [%s]", basePath));
        }
        return uri;
    }

    private URI sanitizeURI(URI uri, String suffix) {
        String string = uri.toString();
        if (string.endsWith("/")) {
            try {
                return new URI(string.substring(0, string.length() - 1) + suffix);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return new URI(string + suffix);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI resolverFile(URI basePath, Map<String, JarEntry> entryList, String insideJarRelativePath, String substring) {
        if (!entryList.containsKey(substring)) {
            if (entryList.containsKey(insideJarRelativePath + ".js/")) {
                return this.sanitizeURI(basePath, ".js");
            }
            if (entryList.containsKey(insideJarRelativePath + ".js")) {
                return this.sanitizeURI(basePath, ".js");
            }
            if (entryList.containsKey(substring + ".js/")) {
                return this.sanitizeURI(basePath, ".js");
            }
            if (entryList.containsKey(substring + ".js")) {
                return this.sanitizeURI(basePath, ".js");
            }
            return null;
        }
        if (entryList.get(substring).isDirectory()) {
            if (entryList.containsKey(insideJarRelativePath + "/index.js")) {
                return this.sanitizeURI(basePath, "/index.js");
            }
            if (entryList.containsKey(substring + "index.js")) {
                return this.sanitizeURI(basePath, "/index.js");
            }
            return null;
        }
        if (basePath.toString().endsWith("/")) {
            try {
                return new URI(basePath.toString().substring(0, basePath.toString().length() - 1));
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return basePath;
    }

    private URI getModuleRealURIWithFileScheme(URI basePath) {
        File file = new File(basePath.getPath());
        if (!file.exists()) {
            File newFile = new File(file.toString() + ".js");
            if (!newFile.exists()) {
                throw new IllegalArgumentException(String.format("Error: invalid path [%s]", basePath));
            }
            return newFile.toURI();
        }
        if (file.isDirectory()) {
            File newFile = new File(file.toString(), "index.js");
            if (!newFile.exists()) {
                throw new IllegalArgumentException(String.format("Error: invalid path [%s]", basePath));
            }
            return newFile.toURI();
        }
        return basePath;
    }
}

