/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.rhinodo.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class JarURIHelper {
    private String insideJarRelativePath;
    private URL jarURL;

    public JarURIHelper(URI jarURI) {
        String fullURI = jarURI.getSchemeSpecificPart();
        String[] jarFileURIParts = fullURI.split("!");
        if (jarFileURIParts.length != 2) {
            throw new IllegalArgumentException("Invalid jar URI specified");
        }
        String insideJarRelativePath = jarFileURIParts[1];
        if (insideJarRelativePath.startsWith("/")) {
            insideJarRelativePath = insideJarRelativePath.substring(1);
        }
        this.insideJarRelativePath = insideJarRelativePath;
        try {
            this.jarURL = new URL(jarFileURIParts[0]);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getInsideJarRelativePath() {
        return this.insideJarRelativePath;
    }

    public URL getJarURL() {
        return this.jarURL;
    }

    public boolean exists() {
        String insideJarRelativePath = this.getInsideJarRelativePath();
        return this.getEntryList().containsKey(insideJarRelativePath);
    }

    public List<JarEntry> getListOfJarFiles() {
        URL jarURL = this.getJarURL();
        ArrayList<JarEntry> listOfJarEntries = new ArrayList<JarEntry>();
        try {
            JarEntry jarEntry;
            JarInputStream jarInputStream = new JarInputStream(jarURL.openStream());
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                listOfJarEntries.add(jarEntry);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return listOfJarEntries;
    }

    public Map<String, JarEntry> getEntryList() {
        HashMap<String, JarEntry> entryList = new HashMap<String, JarEntry>();
        List<JarEntry> listOfJarFiles = this.getListOfJarFiles();
        for (JarEntry jarEntry : listOfJarFiles) {
            entryList.put(jarEntry.getName(), jarEntry);
        }
        return entryList;
    }

    public void copyToFolder(String destDir) throws IOException {
        JarFile jar = null;
        jar = new JarFile(this.jarURL.getFile());
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry file = e.nextElement();
            File f = new File(destDir + File.separator + file.getName());
            if (file.isDirectory()) {
                f.mkdir();
                continue;
            }
            if (f.exists()) continue;
            InputStream is = null;
            try {
                is = jar.getInputStream(file);
            }
            catch (IOException e1) {
                throw new RuntimeException(e1);
            }
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
    }
}

