/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.mule.tools.maven.plugin.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactFilter {
    private Set<Artifact> projectArtifacts;
    private List<Exclusion> excludes;

    public ArtifactFilter(MavenProject project, List<Exclusion> exclusions) {
        this.projectArtifacts = project.getArtifacts();
        this.excludes = exclusions;
    }

    public Set<Artifact> getArtifactsToArchive() {
        Set<Artifact> filteredArtifacts = this.keepOnlyArtifactsWithCompileOrRuntimeScope();
        filteredArtifacts = this.applyAllExcludes(filteredArtifacts);
        return filteredArtifacts;
    }

    private Set<Artifact> keepOnlyArtifactsWithCompileOrRuntimeScope() {
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : this.projectArtifacts) {
            String scope = artifact.getScope();
            if (!"compile".equals(scope) && !"runtime".equals(scope)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private Set<Artifact> applyAllExcludes(Set<Artifact> artifacts) {
        if (this.excludes != null) {
            for (Exclusion exclude : this.excludes) {
                artifacts = this.applyExclude(exclude, artifacts);
            }
        }
        return artifacts;
    }

    private Set<Artifact> applyExclude(Exclusion exclude, Set<Artifact> artifacts) {
        String filter = exclude.toString();
        HashSet<Artifact> filteredArtifacts = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (this.dependencyTrailContains(artifact, filter)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private boolean dependencyTrailContains(Artifact artifact, String filter) {
        List dependencyTrail = artifact.getDependencyTrail();
        for (Object trailElement : dependencyTrail) {
            if (!trailElement.toString().startsWith(filter)) continue;
            return true;
        }
        return false;
    }
}

