/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.mule.tools.maven.plugin.AbstractMuleMojo;
import org.mule.tools.maven.plugin.ArtifactFilter;
import org.mule.tools.maven.plugin.Exclusion;
import org.mule.tools.maven.plugin.MuleArchiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleMojo
extends AbstractMuleMojo {
    private MavenProjectHelper projectHelper;
    private File classesDirectory;
    private boolean archiveClasses;
    private List<Exclusion> exclusions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File app = new File(this.outputDirectory, this.finalName + ".zip");
        try {
            this.createMuleApp(app);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Exception creating the Mule App", (Exception)((Object)e));
        }
        this.projectHelper.attachArtifact(this.project, "zip", app);
    }

    protected void createMuleApp(File app) throws MojoExecutionException, ArchiverException {
        this.validateProject();
        MuleArchiver archiver = new MuleArchiver();
        archiver.addResources(this.appDirectory);
        if (!this.archiveClasses) {
            this.addClassesFolder(archiver);
        } else {
            this.addArchivedClasses(archiver);
        }
        this.addDependencies(archiver);
        archiver.setDestFile(app);
        try {
            app.delete();
            archiver.createArchive();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot create archive", (Throwable)e);
        }
    }

    private void validateProject() throws MojoExecutionException {
        File muleConfig = new File(this.appDirectory, "mule-config.xml");
        File deploymentDescriptor = new File(this.appDirectory, "mule-deploy.properties");
        if (!muleConfig.exists() && !deploymentDescriptor.exists()) {
            String message = String.format("No mule-config.xml or mule-deploy.properties in %1s", this.project.getBasedir());
            this.getLog().error((CharSequence)message);
            throw new MojoExecutionException(message);
        }
    }

    private void addClassesFolder(MuleArchiver archiver) throws ArchiverException {
        if (this.classesDirectory.exists()) {
            this.getLog().info((CharSequence)"Copying classes directly");
            archiver.addClasses(this.classesDirectory, null, null);
        } else {
            this.getLog().info((CharSequence)"target/classes does not exist, skipping");
        }
    }

    private void addArchivedClasses(MuleArchiver archiver) throws ArchiverException, MojoExecutionException {
        this.getLog().info((CharSequence)"Copying classes as a jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.addDirectory(this.classesDirectory, null, null);
        File jar = new File(this.outputDirectory, this.finalName + ".jar");
        jarArchiver.setDestFile(jar);
        try {
            jarArchiver.createArchive();
            archiver.addLib(jar);
        }
        catch (IOException e) {
            String message = "Cannot create project jar";
            this.getLog().error((CharSequence)"Cannot create project jar", (Throwable)e);
            throw new MojoExecutionException("Cannot create project jar", (Exception)e);
        }
    }

    private void addDependencies(MuleArchiver archiver) throws ArchiverException {
        for (Artifact artifact : this.getArtifactsToArchive()) {
            String message = String.format("Adding <%1s> as a lib", artifact.getId());
            this.getLog().info((CharSequence)message);
            archiver.addLib(artifact.getFile());
        }
    }

    private Set<Artifact> getArtifactsToArchive() {
        return new ArtifactFilter(this.project, this.exclusions).getArtifactsToArchive();
    }
}

