/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.muleesb.cloudhub;

import com.mulesoft.cloudhub.client.Connection;
import com.mulesoft.cloudhub.client.DomainConnection;
import com.mulesoft.muleesb.cloudhub.CloudHubAdapter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractCloudHubMojo
extends AbstractMojo {
    @Parameter(property="cloudhub.url", defaultValue="https://cloudhub.io/")
    protected String url;
    @Parameter(property="cloudhub.domain", required=true)
    protected String domain;
    @Parameter(property="cloudhub.username", required=true)
    protected String username;
    @Parameter(property="cloudhub.password", required=true)
    protected String password;
    @Parameter(property="cloudhub.timeout", defaultValue="500000")
    protected long timeout;
    protected CloudHubAdapter cloudhub;

    public void execute() throws MojoExecutionException {
        Connection connection = new Connection(this.url, this.username, this.password);
        DomainConnection domainService = connection.on(this.domain);
        this.cloudhub = new CloudHubAdapter(connection, domainService);
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException;
}

