/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.muleesb.cloudhub;

import com.mulesoft.cloudhub.client.Application;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.mulesoft.cloudhub.client.Connection;
import com.mulesoft.cloudhub.client.DomainConnection;
import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.maven.plugin.MojoExecutionException;

public class CloudHubAdapter {
    private static Logger logger = Logger.getLogger(CloudHubAdapter.class.getName());
    private final Connection connection;
    private final DomainConnection domain;

    public CloudHubAdapter(Connection connection, DomainConnection domain) {
        this.connection = connection;
        this.domain = domain;
    }

    public void deploy(File application, String muleVersion, int workers, long timeout, Map<String, String> properties) throws MojoExecutionException {
        try {
            Application applicationMetadata = this.getApplication(muleVersion, workers, properties);
            this.domain.available();
            this.connection.createApplication(applicationMetadata);
            logger.info("Deploying application: " + application);
            logger.info("to domain " + this.domain.getDomain() + " with Mule Runtime " + muleVersion + " using " + workers + " workers");
            logger.info("using properties: " + properties);
            this.domain.deploy(application, muleVersion, workers, timeout, properties);
        }
        catch (CloudHubException e) {
            throw new MojoExecutionException("Failed to deploy application: " + application, (Exception)((Object)e));
        }
    }

    public void undeploy() throws MojoExecutionException {
        try {
            this.domain.stop();
            this.domain.delete();
        }
        catch (CloudHubException e) {
            throw new MojoExecutionException("Failed to undeploy domain: " + this.domain.getDomain(), (Exception)((Object)e));
        }
    }

    private Application getApplication(String muleVersion, int workers, Map<String, String> properties) {
        Application app = new Application();
        app.setDomain(this.domain.getDomain());
        app.setWorkers(workers);
        app.setProperties(properties);
        app.setMuleVersion(muleVersion);
        return app;
    }
}

