package com.mulesoft.exchange.mavenfacade;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;

import static org.twdata.maven.mojoexecutor.MojoExecutor.*;

public class ExchangeEOFDeployer {

    // Get from POM.xml
    private String DEPLOY_FILE_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private String DEPLOY_FILE_PLUGIN_ARTIFACT_ID = "maven-deploy-plugin";
    private String DEPLOY_FILE_PLUGIN_VERSION = "2.8.2";

    private MavenPluginParameters mavenPluginParameters;

    public ExchangeEOFDeployer(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    public void deploy() {
        MavenProject parentMavenProject = mavenPluginParameters.getMavenProject();
        MavenProject mavenProject = new MavenProject();

        mavenProject.setGroupId(parentMavenProject.getGroupId());
        mavenProject.setArtifactId(parentMavenProject.getArtifactId());
        mavenProject.setVersion(parentMavenProject.getVersion());
        mavenProject.setRemoteArtifactRepositories(parentMavenProject.getRemoteArtifactRepositories());
        mavenProject.setPluginArtifactRepositories(parentMavenProject.getPluginArtifactRepositories());

        MavenSession mavenSession = mavenPluginParameters.getMavenSession().clone();
        mavenSession.setProjects(Arrays.asList(mavenProject));

        File file = null;
        try {
            file = File.createTempFile("exchange", ".eof");
        } catch (IOException e) {
            throw new RuntimeException("Failed creating exchange-eof.json file", e);
        }

        try {
            mavenPluginParameters.getLogger().info("Executing Exchange EOFs deployer");

            ArtifactRepository repo = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();

            // String repoURL = repo.getUrl();
            String artifactId = mavenProject.getArtifactId();
            String groupId = mavenProject.getGroupId();
            String version = mavenProject.getVersion();

            Plugin deployFilePlugin = plugin(groupId(DEPLOY_FILE_PLUGIN_GROUP_ID), artifactId(DEPLOY_FILE_PLUGIN_ARTIFACT_ID), version(DEPLOY_FILE_PLUGIN_VERSION));
            String goal = goal("deploy-file");
            Xpp3Dom pluginConfiguration = configuration(
                    element(name("file"), file.getAbsolutePath()),
                    element(name("repositoryId"), repo.getId()),
                    element(name("url"), repo.getUrl()),
                    element(name("artifactId"), artifactId),
                    element(name("groupId"), groupId),
                    element(name("version"), version),
                    element(name("classifier"), "exchange-eof"),
                    element(name("packaging"), "json"),
                    element(name("generatePom"), "false")
            );

            ExecutionEnvironment executionEnvironment = executionEnvironment(mavenProject, mavenSession, mavenPluginParameters.getPluginManager());

            MojoExecutor.executeMojo(deployFilePlugin, goal, pluginConfiguration, executionEnvironment);
        } catch (Exception e) {
            throw new RuntimeException("Failed uploading exchange.eof file", e);
        } finally {
            file.delete();
        }
    }
}
