package com.mulesoft.exchange.mavenfacade;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name = "exchange-deploy")
public class PublicationMojo extends AbstractExchangeMojo {

    public void doExecute() throws MojoExecutionException {
        MavenPluginParameters mavenPluginParameters = new MavenPluginParameters(mavenProject, mavenSession, pluginManager, getLog());
        ArtifactRepository repository = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();

        if (exchangeUriChecker.isMavenV3RunIdUri(repository.getUrl())) {
            ExchangeDocsDeployer exchangeDocsDeployer = new ExchangeDocsDeployer(mavenPluginParameters, new DeployFilePlugin(mavenPluginParameters));
            ExchangeEOFDeployer exchangeEOFDeployer = new ExchangeEOFDeployer(mavenPluginParameters);

            PublicationStatusProvider publicationStatusProvider = new PublicationStatusProvider(mavenPluginParameters, exchangeUriChecker);
            PublicationStatusChecker publicationStatusChecker = new PublicationStatusChecker(publicationStatusProvider, exchangeUriChecker, getLog());
            try {
                // Zip and upload exchange-docs
                exchangeDocsDeployer.deploy();
                // Upload the exchange-eof.json
                exchangeEOFDeployer.deploy();
                // Check publication status
                publicationStatusChecker.checkStatus();

            } catch (Exception e) {
                throw new MojoExecutionException("Exchange publication failed", e);
            }
        }

    }
}
