/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.DeployFilePlugin;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import java.io.File;
import java.io.IOException;

public class ExchangeEOFDeployer {
    private MavenPluginParameters mavenPluginParameters;

    public ExchangeEOFDeployer(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    public void deploy() {
        File file = this.createExchangeEOFFile();
        this.mavenPluginParameters.getLogger().info((CharSequence)"Executing Exchange EOFs deployer");
        DeployFilePlugin plugin = new DeployFilePlugin(this.mavenPluginParameters);
        try {
            plugin.deployFile(file.getAbsolutePath(), "exchange-eof", "json");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed uploading exchange.eof file", e);
        }
        finally {
            file.delete();
        }
    }

    private File createExchangeEOFFile() {
        try {
            return File.createTempFile("exchange", ".eof");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed creating exchange-eof.json file", e);
        }
    }
}

