/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.DeployFilePlugin;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.exceptions.InvalidIconExtensionException;
import com.mulesoft.exchange.mavenfacade.utils.DeployerUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class ExchangeIconDeployer {
    private final DeployerUtils deployerUtils;
    private final Log logger;
    private static final String ICON_FILE_NAME = "icon";
    private static final String FILE_NAME_EXTENSION_REGEX = "\\.(?=[^.]+$)";

    public ExchangeIconDeployer(MavenPluginParameters mavenPluginParameters, DeployFilePlugin deployFilePlugin) {
        this.deployerUtils = new DeployerUtils(mavenPluginParameters, deployFilePlugin);
        this.logger = mavenPluginParameters.getLogger();
    }

    public void deploy() {
        String exchangeDocsPath = this.deployerUtils.getExchangeDocsPath();
        if (!this.deployerUtils.directoryExists(exchangeDocsPath)) {
            return;
        }
        File[] iconFiles = new File(exchangeDocsPath).listFiles(new IconFilenameFilter());
        if (iconFiles == null || iconFiles.length == 0) {
            return;
        }
        File icon = iconFiles[0];
        String packaging = icon.getName().split(FILE_NAME_EXTENSION_REGEX)[1];
        this.logger.info((CharSequence)("Attempting icon upload of file " + icon.getAbsolutePath() + " with packaging " + packaging));
        this.deployerUtils.deploy(icon.getAbsolutePath(), ICON_FILE_NAME, packaging);
    }

    static class IconFilenameFilter
    implements FilenameFilter {
        private static final List<String> VALID_EXTENSIONS = Arrays.asList("jpg", "jpeg", "png", "gif", "svg");

        IconFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String fullName) {
            boolean isFileWithoutExtension;
            boolean isDirectory = new File(dir.getAbsolutePath(), fullName).isDirectory();
            String[] nameAndExtension = fullName.split(ExchangeIconDeployer.FILE_NAME_EXTENSION_REGEX);
            boolean bl = isFileWithoutExtension = nameAndExtension.length < 2;
            if (isDirectory || isFileWithoutExtension) {
                return false;
            }
            String name = nameAndExtension[0];
            String extension = nameAndExtension[1];
            if (!name.equals(ExchangeIconDeployer.ICON_FILE_NAME)) {
                return false;
            }
            if (VALID_EXTENSIONS.contains(extension)) {
                return true;
            }
            throw new InvalidIconExtensionException("File detected as icon but with invalid extension: " + fullName + ". Valid extensions are " + VALID_EXTENSIONS);
        }
    }
}

