/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mulesoft.exchange.mavenfacade.PublicationStatusProvider;
import com.mulesoft.exchange.mavenfacade.dto.Status;
import com.mulesoft.exchange.mavenfacade.dto.Step;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class PublicationStatusChecker {
    private static final Integer GET_STATUS_MAX_RETRIES = 30;
    private static final Integer GET_STATUS_DELAY = 1000;
    private PublicationStatusProvider publicationStatusProvider;
    private ExchangeUriChecker exchangeUriChecker;
    private Log logger;

    public PublicationStatusChecker(PublicationStatusProvider publicationStatusProvider, ExchangeUriChecker exchangeUriChecker, Log logger) {
        this.publicationStatusProvider = publicationStatusProvider;
        this.exchangeUriChecker = exchangeUriChecker;
        this.logger = logger;
    }

    public void checkStatus() throws InterruptedException {
        Status status = new Status("initial");
        int attempt = 0;
        while (!status.getStatus().equals("completed") && !status.getStatus().equals("error")) {
            this.logger.info((CharSequence)"Getting publication status");
            if (attempt > GET_STATUS_MAX_RETRIES) {
                throw new RuntimeException("Asset publication didn't finish in the expected time");
            }
            try {
                status = (Status)this.publicationStatusProvider.getStatus();
                this.logger.info((CharSequence)"  ------------------------------------------------------------");
                this.logger.info((CharSequence)("  Publication status: " + status.getStatus()));
                this.logger.info((CharSequence)"  ------------------------------------------------------------");
                this.logger.info((CharSequence)"    Steps: ");
                for (Step step : status.getSteps()) {
                    this.logger.info((CharSequence)("    - Description: " + step.getDescription()));
                    this.logger.info((CharSequence)("    - Status: " + step.getStatus()));
                    if (step.getErrors() != null && !step.getErrors().isEmpty()) {
                        this.logger.info((CharSequence)("    - Errors: " + step.getErrors()));
                    }
                    this.logger.info((CharSequence)"    .........................................");
                }
            }
            catch (Exception e) {
                this.logger.warn((CharSequence)"Failed to get publication status", (Throwable)e);
            }
            Thread.sleep(GET_STATUS_DELAY.intValue());
            ++attempt;
        }
        if (status.getStatus().equals("error")) {
            List<Step> steps = status.getSteps();
            Step lastStep = steps.get(steps.size() - 1);
            throw new RuntimeException("Publication ended with errors: " + lastStep.getErrors());
        }
        if (status.getStatus().equals("completed")) {
            MavenProject mavenProject = this.publicationStatusProvider.getMavenPluginParameters().getMavenProject();
            String groupId = mavenProject.getGroupId();
            String assetId = mavenProject.getArtifactId();
            String version = mavenProject.getVersion();
            String basePlatformUri = this.exchangeUriChecker.extractBaseAnypointUriFromMavenRepositoryUri(mavenProject.getDistributionManagementArtifactRepository().getUrl());
            ArrayList elements = Lists.newArrayList((Object[])basePlatformUri.split("/"));
            elements.add("exchange");
            elements.add(groupId);
            elements.add(assetId);
            elements.add(version);
            String assetUri = Joiner.on((String)"/").skipNulls().join((Iterable)elements);
            this.logger.info((CharSequence)"");
            this.logger.info((CharSequence)"  Your asset has been successfully published to Exchange.");
            this.logger.info((CharSequence)("  You can check it at: " + assetUri));
        }
    }
}

