package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.utils.DeployerUtils;
import com.mulesoft.exchange.mavenfacade.utils.ZipUtils;
import org.apache.maven.plugin.logging.Log;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import static com.mulesoft.exchange.mavenfacade.utils.DeployerUtils.EXCHANGE_DOCS_DIR;

public class ExchangeDocsDeployer {
    private final DeployerUtils deployerUtils;
    private final Log logger;
    public static final String ZIPPED_EXCHANGE_DOCS_FILE = "exchange-docs.zip";

    public ExchangeDocsDeployer(MavenPluginParameters mavenPluginParameters, DeployFilePlugin deployFilePlugin) {
        this.deployerUtils = new DeployerUtils(mavenPluginParameters, deployFilePlugin);
        this.logger = mavenPluginParameters.getLogger();
    }

    public void deploy() {
        String exchangeDocsPath = deployerUtils.getExchangeDocsPath();
        if (deployerUtils.directoryExists(exchangeDocsPath)) {
            if(deployerUtils.directoryIsEmpty(exchangeDocsPath)) {
                throw new RuntimeException("The " + EXCHANGE_DOCS_DIR + " (path: " + exchangeDocsPath + ") directory can not be empty.");
            }
            deployExchangeDocs(exchangeDocsPath);
        }
    }


    private void deployExchangeDocs(String exchangeDocsPath) {
        String zippedDocsPath = zipExchangeDocs(exchangeDocsPath);
        logger.info("Executing Exchange Docs deployer");
        deployerUtils.deploy(zippedDocsPath, "docs", "zip");
    }

    private String zipExchangeDocs(String exchangeDocsPath) {
        try {
            Path tmpDirectory = Files.createTempDirectory(EXCHANGE_DOCS_DIR);
            String tmpDirectoryPath = tmpDirectory.toAbsolutePath().toString();
            String zippedDocsPath = tmpDirectoryPath + "/" + ZIPPED_EXCHANGE_DOCS_FILE;

            ZipUtils.compressDirectoryContent(exchangeDocsPath, zippedDocsPath);
            return zippedDocsPath;
        } catch (IOException e) {
            throw new RuntimeException("Failed creating " + ZIPPED_EXCHANGE_DOCS_FILE + " file", e);
        }
    }
}
