/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import com.mulesoft.exchange.mavenfacade.utils.UUIDGenerator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;

public class ExchangeRepositoryBuilder {
    private static String RUN_ID_PARAMETER = "runId";
    private static String X_DEPLOY_ID_HEADER = "X-EXCHANGE-DEPLOY-ID";

    public static void updateRepositoryUri(MavenProject project, Properties systemProperties) {
        DeploymentRepository repository;
        DistributionManagement management = project.getDistributionManagement();
        DeploymentRepository deploymentRepository = repository = management != null ? management.getRepository() : null;
        if (repository != null && ExchangeUriChecker.isMavenV3Uri(repository.getUrl())) {
            String xRunId = (String)systemProperties.get(X_DEPLOY_ID_HEADER);
            if (xRunId == null) {
                xRunId = String.valueOf(UUIDGenerator.generate());
                systemProperties.setProperty(X_DEPLOY_ID_HEADER, xRunId);
            }
            ExchangeRepositoryBuilder.injectRunIdIntoMavenProjectArtifacts(project, xRunId);
        }
    }

    public static void injectRunIdIntoMavenProjectArtifacts(MavenProject project, String xRunId) {
        ArtifactRepository managementArtifactRepository;
        List remoteArtifactRepositories = project.getRemoteArtifactRepositories();
        ArtifactRepository exchangeRemoteArtifact = null;
        for (ArtifactRepository artifactRepository : remoteArtifactRepositories) {
            if (!ExchangeUriChecker.isMavenV3Uri(artifactRepository.getUrl())) continue;
            exchangeRemoteArtifact = artifactRepository;
            break;
        }
        if (exchangeRemoteArtifact != null) {
            ExchangeRepositoryBuilder.injectRunIdIntoArtifact(exchangeRemoteArtifact, xRunId);
        }
        if (ExchangeUriChecker.isMavenV3Uri((managementArtifactRepository = project.getDistributionManagementArtifactRepository()).getUrl())) {
            ExchangeRepositoryBuilder.injectRunIdIntoArtifact(managementArtifactRepository, xRunId);
        }
    }

    private static void injectRunIdIntoArtifact(ArtifactRepository repository, String xRunId) {
        repository.setUrl(repository.getUrl() + "/" + RUN_ID_PARAMETER + "/" + xRunId);
    }
}

