/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExchangeUriChecker {
    private static final Pattern exchangeRepositoryUriPattern = Pattern.compile("^https://.*anypoint\\.mulesoft\\.com/api/v[1-3]/organizations/(.*)/maven$");
    private static final Pattern exchangeV3RepositoryUriPattern = Pattern.compile("^https://.*anypoint\\.mulesoft\\.com/api/v3/organizations/(.*)/maven$");
    private static final Pattern exchangeV3RepositoryWithoutOrganizationUriPattern = Pattern.compile("^https://.*anypoint\\.mulesoft\\.com/api/v3/maven$");
    private static final Pattern exchangeV3RunIdRepositoryUriPattern = Pattern.compile("^https://.*anypoint\\.mulesoft\\.com/api/v3/organizations/(.*)/maven/runId/(.+)$");
    private static final Pattern anypointPrefixUriPattern = Pattern.compile("^https://maven\\.(.*anypoint\\.mulesoft\\.com/)");

    public static boolean isExchangeRepo(String uri) {
        return exchangeRepositoryUriPattern.matcher(uri).matches();
    }

    public static String extractOrganizationIdFromExchangeRepositoryUri(String uri) {
        String organizationId = null;
        Matcher matcher = exchangeRepositoryUriPattern.matcher(uri);
        if (matcher.matches()) {
            organizationId = matcher.group(1);
        }
        return organizationId;
    }

    public static String extractBaseAnypointUriFromMavenRepositoryUri(String uri) {
        String baseUri = null;
        Matcher matcher = anypointPrefixUriPattern.matcher(uri);
        if (matcher.find()) {
            baseUri = "https://" + matcher.group(1);
        }
        return baseUri;
    }

    public static boolean isMavenV3Uri(String uri) {
        return exchangeV3RepositoryUriPattern.matcher(uri).matches();
    }

    public static boolean isMavenV3UriWithoutOrganization(String uri) {
        return exchangeV3RepositoryWithoutOrganizationUriPattern.matcher(uri).matches();
    }

    public static boolean isMavenV3RunIdUri(String uri) {
        return exchangeV3RunIdRepositoryUriPattern.matcher(uri).matches();
    }

    public static void validateMavenV3RunIdUri(String uri) throws RuntimeException {
        if (!ExchangeUriChecker.isMavenV3RunIdUri(uri)) {
            throw new RuntimeException("Repository url is not valid. It should follow this pattern: " + exchangeV3RunIdRepositoryUriPattern.pattern());
        }
    }
}

