/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeUriChecker {
    private static final String exchangeAnypointDomain = "https://.*anypoint\\.mulesoft\\.com";
    private static final String exchangeRepositoryBasePath = "/api/v[1-3]/organizations/(.+)/maven$";
    private static final String exchangeV3RepositoryBasePath = "/api/v3/organizations/(.*)/maven$";
    private static final String exchangeV3RepositoryWithoutOrganizationIdBasePath = "/api/v3/maven$";
    private static final String exchangeV3RunIdRepositoryUriBasePath = "/api/v3/organizations/(.+)/maven/runId/(.+)$";
    private final Pattern anypointPrefixUriPattern = Pattern.compile("^https://maven\\.(.*anypoint\\.mulesoft\\.com/)");
    private List<Pattern> exchangeRepositoryUriPatterns;
    private List<Pattern> exchangeV3RepositoryUriPatterns;
    private List<Pattern> exchangeV3RepositoryUriWithoutOrganizationPatterns;
    private List<Pattern> exchangeV3RunIdRepositoryUriPatterns;
    private List<String> customDomains;

    public ExchangeUriChecker() {
        this(new ArrayList<String>());
    }

    public ExchangeUriChecker(List<String> customDomains) {
        this.customDomains = customDomains;
        this.exchangeRepositoryUriPatterns = this.getPatterns(exchangeRepositoryBasePath);
        this.exchangeV3RepositoryUriPatterns = this.getPatterns(exchangeV3RepositoryBasePath);
        this.exchangeV3RepositoryUriWithoutOrganizationPatterns = this.getPatterns(exchangeV3RepositoryWithoutOrganizationIdBasePath);
        this.exchangeV3RunIdRepositoryUriPatterns = this.getPatterns(exchangeV3RunIdRepositoryUriBasePath);
    }

    public boolean isExchangeRepo(String uri) {
        for (Pattern exchangeRepositoryUriPattern : this.exchangeRepositoryUriPatterns) {
            if (!exchangeRepositoryUriPattern.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    public String extractOrganizationIdFromExchangeRepositoryUri(String uri) {
        String organizationId = null;
        for (Pattern exchangeRepositoryUriPattern : this.exchangeRepositoryUriPatterns) {
            Matcher matcher = exchangeRepositoryUriPattern.matcher(uri);
            if (!matcher.matches()) continue;
            organizationId = matcher.group(1);
            break;
        }
        return organizationId;
    }

    public String extractBaseAnypointUriFromMavenRepositoryUri(String uri) {
        if (this.customDomains.size() > 0) {
            return this.customDomains.get(0);
        }
        String baseUri = null;
        Matcher matcher = this.anypointPrefixUriPattern.matcher(uri);
        if (matcher.find()) {
            baseUri = "https://" + matcher.group(1);
        }
        return baseUri;
    }

    public boolean isMavenV3Uri(String uri) {
        for (Pattern exchangeV3RepositoryUriPattern : this.exchangeV3RepositoryUriPatterns) {
            if (!exchangeV3RepositoryUriPattern.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isMavenV3UriWithoutOrganization(String uri) {
        for (Pattern exchangeV3RepositoryUriPattern : this.exchangeV3RepositoryUriWithoutOrganizationPatterns) {
            if (!exchangeV3RepositoryUriPattern.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isMavenV3RunIdUri(String uri) {
        for (Pattern exchangeV3RunIdRepositoryUriPattern : this.exchangeV3RunIdRepositoryUriPatterns) {
            if (!exchangeV3RunIdRepositoryUriPattern.matcher(uri).matches()) continue;
            return true;
        }
        return false;
    }

    public void validateMavenV3RunIdUri(String uri) throws RuntimeException {
        if (!this.isMavenV3RunIdUri(uri)) {
            throw new RuntimeException("Repository url is not valid. It should follow one of this patterns: " + this.exchangeV3RunIdRepositoryUriPatterns.toString());
        }
    }

    private List<Pattern> getPatterns(String pathname) {
        ArrayList domains = Lists.newArrayList(this.customDomains);
        domains.add(exchangeAnypointDomain);
        ArrayList patterns = Lists.newArrayList();
        for (String domain : domains) {
            patterns.add(Pattern.compile(String.format("^%s%s", domain, pathname)));
        }
        return patterns;
    }
}

