/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import com.google.gson.Gson;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import com.mulesoft.exchange.mavenfacade.utils.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeHelper {
    private ExchangeUriChecker exchangeUriChecker;
    private List<String> customDomains;
    private final String RUN_ID_PARAMETER = "runId";
    private final String X_DEPLOY_ID_HEADER = "X-EXCHANGE-DEPLOY-ID";
    private final String X_ANYPOINT_CUSTOM_DOMAINS = "X-ANYPOINT-CUSTOM-DOMAINS";

    public ExchangeHelper() {
        this(new ArrayList<String>());
    }

    public ExchangeHelper(List<String> customDomains) {
        this.customDomains = customDomains;
        this.exchangeUriChecker = new ExchangeUriChecker(customDomains);
    }

    public void updateRepositoryUri(MavenProject project, Properties systemProperties) {
        DeploymentRepository repository;
        DistributionManagement management = project.getDistributionManagement();
        DeploymentRepository deploymentRepository = repository = management != null ? management.getRepository() : null;
        if (repository != null && this.exchangeUriChecker.isMavenV3Uri(repository.getUrl())) {
            String xRunId = (String)systemProperties.get("X-EXCHANGE-DEPLOY-ID");
            if (xRunId == null) {
                xRunId = String.valueOf(UUIDGenerator.generate());
                systemProperties.setProperty("X-EXCHANGE-DEPLOY-ID", xRunId);
            }
            this.injectRunIdIntoMavenProjectArtifacts(project, xRunId);
        }
    }

    public void saveCustomDomains(Properties systemProperties) {
        systemProperties.setProperty("X-ANYPOINT-CUSTOM-DOMAINS", new Gson().toJson(this.customDomains));
    }

    public Set<String> retrieveCustomDomains(Properties systemProperties) {
        String storedStringifiedCustomDomains = systemProperties.getProperty("X-ANYPOINT-CUSTOM-DOMAINS", "[]");
        return (Set)new Gson().fromJson(storedStringifiedCustomDomains, HashSet.class);
    }

    private void injectRunIdIntoMavenProjectArtifacts(MavenProject project, String xRunId) {
        ArtifactRepository managementArtifactRepository;
        List remoteArtifactRepositories = project.getRemoteArtifactRepositories();
        ArtifactRepository exchangeRemoteArtifact = null;
        for (ArtifactRepository artifactRepository : remoteArtifactRepositories) {
            if (!this.exchangeUriChecker.isMavenV3Uri(artifactRepository.getUrl())) continue;
            exchangeRemoteArtifact = artifactRepository;
            break;
        }
        if (exchangeRemoteArtifact != null) {
            this.injectRunIdIntoArtifact(exchangeRemoteArtifact, xRunId);
        }
        if (this.exchangeUriChecker.isMavenV3Uri((managementArtifactRepository = project.getDistributionManagementArtifactRepository()).getUrl())) {
            this.injectRunIdIntoArtifact(managementArtifactRepository, xRunId);
        }
    }

    private void injectRunIdIntoArtifact(ArtifactRepository repository, String xRunId) {
        repository.setUrl(repository.getUrl() + "/" + "runId" + "/" + xRunId);
    }
}

