package com.mulesoft.exchange.mavenfacade;

import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name = "exchange-deploy")
public class PublicationMojo extends AbstractMojo {

    @Component
    private MavenProject mavenProject;

    @Component
    private MavenSession mavenSession;

    @Component
    private BuildPluginManager pluginManager;

    public void execute() throws MojoExecutionException {
        MavenPluginParameters mavenPluginParameters = new MavenPluginParameters(mavenProject, mavenSession, pluginManager, getLog());

        ExchangeEOFDeployer exchangeEOFDeployer = new ExchangeEOFDeployer(mavenPluginParameters);
        PublicationStatusProvider publicationStatusProvider = new PublicationStatusProvider(mavenPluginParameters);

        PublicationStatusChecker publicationStatusChecker = new PublicationStatusChecker(publicationStatusProvider, getLog());

        try {
            // Upload the exchange-eof.json
            exchangeEOFDeployer.deploy();
            // Check publication status
            publicationStatusChecker.checkStatus();

        } catch (Exception e) {
            throw new MojoExecutionException("Exchange publication failed", e);
        }

        getLog().info("Everything ok!");
    }

    static class ExchangeEOFDeployerTest {

    }
}
