/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.PublicationStatusProvider;
import com.mulesoft.exchange.mavenfacade.dto.Status;
import com.mulesoft.exchange.mavenfacade.dto.Step;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class PublicationStatusChecker {
    private static final Integer GET_STATUS_MAX_RETRIES = 30;
    private static final Integer GET_STATUS_DELAY = 1000;
    private PublicationStatusProvider publicationStatusProvider;
    private Log logger;

    public PublicationStatusChecker(PublicationStatusProvider publicationStatusProvider, Log logger) {
        this.publicationStatusProvider = publicationStatusProvider;
        this.logger = logger;
    }

    public void checkStatus() throws InterruptedException {
        Status status = new Status("initial");
        int attempt = 0;
        while (!status.getStatus().equals("completed") && !status.getStatus().equals("error")) {
            this.logger.info((CharSequence)"Getting publication status");
            if (attempt > GET_STATUS_MAX_RETRIES) {
                throw new RuntimeException("Asset publication didn't finish in the expected time");
            }
            try {
                status = this.publicationStatusProvider.getStatus();
                this.logger.info((CharSequence)"  ------------------------------------------------------------");
                this.logger.info((CharSequence)("  Publication status: " + status.getStatus()));
                this.logger.info((CharSequence)"  ------------------------------------------------------------");
                this.logger.info((CharSequence)"    Steps: ");
                for (Step step : status.getSteps()) {
                    this.logger.info((CharSequence)("    - Description: " + step.getDescription()));
                    this.logger.info((CharSequence)("    - Status: " + step.getStatus()));
                    if (step.getErrors() != null && !step.getErrors().isEmpty()) {
                        this.logger.info((CharSequence)("    - Errors: " + step.getErrors()));
                    }
                    this.logger.info((CharSequence)"    .........................................");
                }
            }
            catch (Exception e) {
                this.logger.warn((CharSequence)"Failed to get publication status", (Throwable)e);
            }
            Thread.sleep(GET_STATUS_DELAY.intValue());
            ++attempt;
        }
        if (status.getStatus().equals("error")) {
            List<Step> steps = status.getSteps();
            Step lastStep = steps.get(steps.size() - 1);
            throw new RuntimeException("Publication ended with errors: " + lastStep.getErrors());
        }
    }
}

