package com.mulesoft.exchange.mavenfacade;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

import java.util.Properties;

@Mojo(name = "exchange-pre-deploy")
public class PreDeployMojo extends AbstractExchangeMojo {

    public void doExecute() throws MojoExecutionException {
        MavenPluginParameters mavenPluginParameters = new MavenPluginParameters(mavenProject, mavenSession, pluginManager, getLog());
        ArtifactRepository repository = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();
        Properties systemProperties = mavenSession.getRequest().getSystemProperties();
        if (exchangeUriChecker.isMavenV3Uri(repository.getUrl())) {
            try {
                exchangeHelper.updateRepositoryUri(mavenProject, systemProperties);

                PublicationPreConditionsProvider publicationStatusProvider = new PublicationPreConditionsProvider(mavenPluginParameters, exchangeUriChecker);

                PublicationPreConditionsChecker publicationPreConditionsChecker = new PublicationPreConditionsChecker(publicationStatusProvider, getLog());

                // Check publication status
                publicationPreConditionsChecker.checkStatus();
            } catch (Exception e) {
                throw new MojoExecutionException("Exchange publication failed", e);
            }

            getLog().info("Everything ok!");
        }
    }
}
