/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.DeployFilePlugin;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ExchangeDocsDeployer {
    private final MavenPluginParameters mavenPluginParameters;
    private final DeployFilePlugin deployFilePlugin;
    public static final String EXCHANGE_DOCS_DIR = "exchange-docs";
    public static final String ZIPPED_EXCHANGE_DOCS_FILE = "exchange-docs.zip";

    public ExchangeDocsDeployer(MavenPluginParameters mavenPluginParameters, DeployFilePlugin deployFilePlugin) {
        this.mavenPluginParameters = mavenPluginParameters;
        this.deployFilePlugin = deployFilePlugin;
    }

    public void deploy() {
        String exchangeDocsPath = this.getExchangeDocsPath();
        if (this.directoryExists(exchangeDocsPath)) {
            if (this.directoryIsEmpty(exchangeDocsPath)) {
                throw new RuntimeException("The exchange-docs (path: " + exchangeDocsPath + ") directory can not be empty.");
            }
            this.deployExchangeDocs(exchangeDocsPath);
        }
    }

    private boolean directoryIsEmpty(String exchangeDocsPath) {
        File file = new File(exchangeDocsPath);
        return file.isDirectory() && file.list().length == 0;
    }

    private String getExchangeDocsPath() {
        String projectBasePath = this.mavenPluginParameters.getMavenProjectAbsolutePath();
        return projectBasePath + "/" + EXCHANGE_DOCS_DIR;
    }

    private boolean directoryExists(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        return Files.isDirectory(path, new LinkOption[0]);
    }

    private void deployExchangeDocs(String exchangeDocsPath) {
        String zippedDocsPath = this.zipExchangeDocs(exchangeDocsPath);
        this.mavenPluginParameters.getLogger().info((CharSequence)"Executing Exchange Docs deployer");
        try {
            this.deployFilePlugin.deployFile(zippedDocsPath, "docs", "zip");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed uploading exchange-docs.zip file", e);
        }
    }

    private String zipExchangeDocs(String exchangeDocsPath) {
        try {
            Path tmpDirectory = Files.createTempDirectory(EXCHANGE_DOCS_DIR, new FileAttribute[0]);
            String tmpDirectoryPath = tmpDirectory.toAbsolutePath().toString();
            String zippedDocsPath = tmpDirectoryPath + "/" + ZIPPED_EXCHANGE_DOCS_FILE;
            ZipUtils.compressDirectoryContent((String)exchangeDocsPath, (String)zippedDocsPath);
            return zippedDocsPath;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed creating exchange-docs.zip file", e);
        }
    }
}

