/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.DeployFilePlugin;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.utils.DeployerUtils;
import com.mulesoft.exchange.mavenfacade.utils.ZipUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.logging.Log;

public class ExchangeDocsDeployer {
    private final DeployerUtils deployerUtils;
    private final Log logger;
    public static final String ZIPPED_EXCHANGE_DOCS_FILE = "exchange-docs.zip";

    public ExchangeDocsDeployer(MavenPluginParameters mavenPluginParameters, DeployFilePlugin deployFilePlugin) {
        this.deployerUtils = new DeployerUtils(mavenPluginParameters, deployFilePlugin);
        this.logger = mavenPluginParameters.getLogger();
    }

    public void deploy() {
        String exchangeDocsPath = this.deployerUtils.getExchangeDocsPath();
        if (this.deployerUtils.directoryExists(exchangeDocsPath)) {
            if (this.deployerUtils.directoryIsEmpty(exchangeDocsPath)) {
                throw new RuntimeException("The exchange-docs (path: " + exchangeDocsPath + ") directory can not be empty.");
            }
            this.deployExchangeDocs(exchangeDocsPath);
        }
    }

    private void deployExchangeDocs(String exchangeDocsPath) {
        String zippedDocsPath = this.zipExchangeDocs(exchangeDocsPath);
        this.logger.info((CharSequence)"Executing Exchange Docs deployer");
        this.deployerUtils.deploy(zippedDocsPath, "docs", "zip");
    }

    private String zipExchangeDocs(String exchangeDocsPath) {
        try {
            Path tmpDirectory = Files.createTempDirectory("exchange-docs", new FileAttribute[0]);
            String tmpDirectoryPath = tmpDirectory.toAbsolutePath().toString();
            String zippedDocsPath = tmpDirectoryPath + "/" + ZIPPED_EXCHANGE_DOCS_FILE;
            ZipUtils.compressDirectoryContent((String)exchangeDocsPath, (String)zippedDocsPath);
            return zippedDocsPath;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed creating exchange-docs.zip file", e);
        }
    }
}

