/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public abstract class AbstractDynamicJSONFileProvider {
    private String GET_FILE_PLUGIN_GROUP_ID = "com.googlecode.maven-download-plugin";
    private String GET_FILE_PLUGIN_ARTIFACT_ID = "download-maven-plugin";
    private String GET_FILE_PLUGIN_VERSION = "1.5.0";
    private MavenPluginParameters mavenPluginParameters;
    private Class dtoClass;
    private String classifierPrefix;

    public AbstractDynamicJSONFileProvider(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    protected abstract String getClassifier();

    protected abstract Type getDtoClass();

    private HashMap<ArtifactRepository, String> replaceMavenV3Repository(String remoteArtifactUrl, List<ArtifactRepository> remoteArtifactsRepositories) {
        HashMap<ArtifactRepository, String> repositoriesToRestore = new HashMap<ArtifactRepository, String>();
        for (ArtifactRepository artifactRepository : remoteArtifactsRepositories) {
            if (!ExchangeUriChecker.isMavenV3UriWithoutOrganization((String)artifactRepository.getUrl())) continue;
            repositoriesToRestore.put(artifactRepository, artifactRepository.getUrl());
            artifactRepository.setUrl(remoteArtifactUrl);
        }
        return repositoriesToRestore;
    }

    private void restoreMavenV3Repository(HashMap<ArtifactRepository, String> repositoriesToRestore) {
        for (Map.Entry<ArtifactRepository, String> entry : repositoriesToRestore.entrySet()) {
            entry.getKey().setUrl(entry.getValue());
        }
    }

    public <T> T getStatus() {
        MavenProject mavenProject = this.mavenPluginParameters.getMavenProject();
        File tempDir = Files.createTempDir();
        File tempFile = null;
        try {
            String groupId = mavenProject.getGroupId();
            String assetId = mavenProject.getArtifactId();
            String version = mavenProject.getVersion();
            String classifier = this.getClassifier() + "-" + new Date().getTime();
            String packaging = "json";
            String fileName = groupId + ":" + assetId + ":" + version + ":" + classifier + ":" + packaging;
            Plugin deployFilePlugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.GET_FILE_PLUGIN_GROUP_ID), (String)MojoExecutor.artifactId((String)this.GET_FILE_PLUGIN_ARTIFACT_ID), (String)MojoExecutor.version((String)this.GET_FILE_PLUGIN_VERSION));
            String goal = MojoExecutor.goal((String)"artifact");
            Xpp3Dom pluginConfiguration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)groupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)assetId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)version), MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)classifier), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"json"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)tempDir.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"outputFileName"), (String)fileName)});
            List remoteArtifactsRepositories = this.mavenPluginParameters.getMavenProject().getRemoteArtifactRepositories();
            String remoteArtifactUrl = this.mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository().getUrl();
            HashMap<ArtifactRepository, String> remoteArtifactsToRestore = this.replaceMavenV3Repository(remoteArtifactUrl, remoteArtifactsRepositories);
            MojoExecutor.ExecutionEnvironment executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.mavenPluginParameters.getMavenProject(), (MavenSession)this.mavenPluginParameters.getMavenSession(), (BuildPluginManager)this.mavenPluginParameters.getPluginManager());
            MojoExecutor.executeMojo((Plugin)deployFilePlugin, (String)goal, (Xpp3Dom)pluginConfiguration, (MojoExecutor.ExecutionEnvironment)executionEnvironment);
            this.restoreMavenV3Repository(remoteArtifactsToRestore);
            tempFile = new File(tempDir.getAbsolutePath(), fileName);
            Gson gson = new Gson();
            Object object = gson.fromJson((Reader)new FileReader(tempFile), this.getDtoClass());
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while processing the publication", e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
            tempDir.delete();
        }
    }
}

