package com.mulesoft.exchange.mavenfacade;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeHelper;
import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractExchangeMojo extends AbstractMojo {

    @Component
    protected MavenProject mavenProject;

    @Component
    protected MavenSession mavenSession;

    @Component
    protected BuildPluginManager pluginManager;

    @Parameter
    protected List<String> customDomains = new ArrayList<>();

    ExchangeUriChecker exchangeUriChecker;

    public void execute() throws MojoExecutionException {
        initMojo();
        doExecute();
    }

    public abstract void doExecute() throws MojoExecutionException;

    private void initMojo() {
        Set<String> storedCustomDomains = new ExchangeHelper().retrieveCustomDomains(mavenSession.getSystemProperties());

        storedCustomDomains.addAll(customDomains);
        exchangeUriChecker = new ExchangeUriChecker(Lists.newArrayList(storedCustomDomains));
    }
}
