package com.mulesoft.exchange.mavenfacade;

import com.mulesoft.exchange.mavenfacade.utils.ExchangeUriChecker;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name = "exchange-pre-deploy")
public class PreConditionsMojo extends AbstractExchangeMojo {

    public void doExecute() throws MojoExecutionException {
        MavenPluginParameters mavenPluginParameters = new MavenPluginParameters(mavenProject, mavenSession, pluginManager, getLog());
        ArtifactRepository repository = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();
        exchangeUriChecker.validateMavenV3RunIdUri(repository.getUrl());
        
        PublicationPreConditionsProvider publicationStatusProvider = new PublicationPreConditionsProvider(mavenPluginParameters, exchangeUriChecker);

        PublicationPreConditionsChecker publicationPreConditionsChecker = new PublicationPreConditionsChecker(publicationStatusProvider, getLog());

        try {
            // Check publication status
            publicationPreConditionsChecker.checkStatus();

        } catch (Exception e) {
            throw new MojoExecutionException("Exchange publication failed", e);
        }

        getLog().info("Everything ok!");
    }
}
