/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade.utils;

import com.mulesoft.exchange.mavenfacade.DeployFilePlugin;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DeployerUtils {
    public static final String EXCHANGE_DOCS_DIR = "exchange-docs";
    private final MavenPluginParameters mavenPluginParameters;
    private final DeployFilePlugin deployFilePlugin;

    public DeployerUtils(MavenPluginParameters mavenPluginParameters, DeployFilePlugin deployFilePlugin) {
        this.mavenPluginParameters = mavenPluginParameters;
        this.deployFilePlugin = deployFilePlugin;
    }

    public String getExchangeDocsPath() {
        String projectBasePath = this.mavenPluginParameters.getMavenProjectAbsolutePath();
        return Paths.get(projectBasePath, EXCHANGE_DOCS_DIR).toString();
    }

    public boolean directoryExists(String directoryPath) {
        Path path = Paths.get(directoryPath, new String[0]);
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean directoryIsEmpty(String exchangeDocsPath) {
        File file = new File(exchangeDocsPath);
        return file.isDirectory() && file.list().length == 0;
    }

    public void deploy(String filepath, String classifier, String packaging) {
        try {
            this.deployFilePlugin.deployFile(filepath, classifier, packaging);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed uploading " + filepath + " file", e);
        }
    }
}

