package com.mulesoft.exchange.mavenfacade;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

import java.util.Arrays;

import static org.twdata.maven.mojoexecutor.MojoExecutor.*;

public class DeployFilePlugin {
    private final static String DEPLOY_FILE_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private final static String DEPLOY_FILE_PLUGIN_ARTIFACT_ID = "maven-deploy-plugin";
    private final static String DEPLOY_FILE_PLUGIN_VERSION = "2.8.2";
    private final MavenPluginParameters mavenPluginParameters;

    public DeployFilePlugin(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    public void deployFile(String filePath, String classifier, String packaging) throws MojoExecutionException {
        MavenProject mavenProject = createMavenProjectFrom(mavenPluginParameters.getMavenProject());
        ArtifactRepository repo = mavenPluginParameters.getMavenProject().getDistributionManagementArtifactRepository();

        Plugin deployFilePlugin = plugin(groupId(DEPLOY_FILE_PLUGIN_GROUP_ID), artifactId(DEPLOY_FILE_PLUGIN_ARTIFACT_ID), version(DEPLOY_FILE_PLUGIN_VERSION));
        String goal = goal("deploy-file");
        Xpp3Dom pluginConfiguration = configuration(
                element(name("file"), filePath),
                element(name("repositoryId"), repo.getId()),
                element(name("url"), repo.getUrl()),
                element(name("artifactId"), mavenProject.getArtifactId()),
                element(name("groupId"), mavenProject.getGroupId()),
                element(name("version"), mavenProject.getVersion()),
                element(name("classifier"), classifier),
                element(name("packaging"), packaging),
                element(name("generatePom"), "false")
        );

        MavenSession mavenSession = mavenPluginParameters.getMavenSession().clone();
        mavenSession.setProjects(Arrays.asList(mavenProject));

        ExecutionEnvironment executionEnvironment = executionEnvironment(mavenProject, mavenSession, mavenPluginParameters.getPluginManager());
        MojoExecutor.executeMojo(deployFilePlugin, goal, pluginConfiguration, executionEnvironment);
    }

    private MavenProject createMavenProjectFrom(MavenProject parent) {
        MavenProject mavenProject = new MavenProject();
        mavenProject.setGroupId(parent.getGroupId());
        mavenProject.setArtifactId(parent.getArtifactId());
        mavenProject.setVersion(parent.getVersion());
        mavenProject.setRemoteArtifactRepositories(parent.getRemoteArtifactRepositories());
        mavenProject.setPluginArtifactRepositories(parent.getPluginArtifactRepositories());

        return mavenProject;
    }
}
