package com.mulesoft.exchange.mavenfacade;

import java.io.File;
import java.io.IOException;

public class ExchangeEOFDeployer {
    private MavenPluginParameters mavenPluginParameters;

    public ExchangeEOFDeployer(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    public void deploy() {
        File file = createExchangeEOFFile();

        mavenPluginParameters.getLogger().info("Executing Exchange EOFs deployer");
        DeployFilePlugin plugin = new DeployFilePlugin(mavenPluginParameters);
        try {
            plugin.deployFile(file.getAbsolutePath(), "exchange-eof", "json");
        } catch (Exception e) {
            throw new RuntimeException("Failed uploading exchange.eof file", e);
        } finally {
            file.delete();
        }
    }

    private File createExchangeEOFFile() {
        try {
            return File.createTempFile("exchange", ".eof");
        } catch (IOException e) {
            throw new RuntimeException("Failed creating exchange-eof.json file", e);
        }
    }
}
