package com.mulesoft.exchange.mavenfacade;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.mulesoft.exchange.mavenfacade.dto.Status;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

import java.io.File;
import java.io.FileReader;
import java.util.Date;

import static org.twdata.maven.mojoexecutor.MojoExecutor.*;

public class PublicationStatusProvider {

    // Get from POM.xml
    private String GET_FILE_PLUGIN_GROUP_ID = "com.googlecode.maven-download-plugin";
    private String GET_FILE_PLUGIN_ARTIFACT_ID = "download-maven-plugin";
    private String GET_FILE_PLUGIN_VERSION = "1.5.0";

    private MavenPluginParameters mavenPluginParameters;

    public PublicationStatusProvider(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    public Status getStatus() {
        MavenProject mavenProject = mavenPluginParameters.getMavenProject();

        File tempDir = Files.createTempDir();
        File statusFile = null;

        try {
            String groupId = mavenProject.getGroupId();
            String assetId = mavenProject.getArtifactId();
            String version = mavenProject.getVersion();
            String classifier = "status-" + new Date().getTime();
            String packaging = "json";
            String fileName = groupId + ":" + assetId + ":" + version + ":" + classifier + ":" + packaging;

            Plugin deployFilePlugin = plugin(groupId(GET_FILE_PLUGIN_GROUP_ID), artifactId(GET_FILE_PLUGIN_ARTIFACT_ID), version(GET_FILE_PLUGIN_VERSION));
            String goal = goal("artifact");

            Xpp3Dom pluginConfiguration = configuration(
                    element(name("groupId"), groupId),
                    element(name("artifactId"), assetId),
                    element(name("version"), version),
                    element(name("classifier"), classifier),
                    element(name("type"), "json"),
                    element(name("outputDirectory"), tempDir.getAbsolutePath()),
                    element(name("outputFileName"), fileName)
            );

            ExecutionEnvironment executionEnvironment = executionEnvironment(mavenPluginParameters.getMavenProject(), mavenPluginParameters.getMavenSession(), mavenPluginParameters.getPluginManager());

            MojoExecutor.executeMojo(deployFilePlugin, goal, pluginConfiguration, executionEnvironment);

            statusFile = new File(tempDir.getAbsolutePath(), fileName);

            Gson gson = new Gson();
            return gson.fromJson(new FileReader(statusFile), Status.class);
        } catch (Exception e) {
            throw new RuntimeException("Unexpected error while getting the publication status", e);
        } finally {
            if (statusFile != null) {
                statusFile.delete();
            }

            tempDir.delete();
        }
    }
}
