/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.exchange.mavenfacade;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.mulesoft.exchange.mavenfacade.MavenPluginParameters;
import com.mulesoft.exchange.mavenfacade.dto.Status;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Date;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class PublicationStatusProvider {
    private String GET_FILE_PLUGIN_GROUP_ID = "com.googlecode.maven-download-plugin";
    private String GET_FILE_PLUGIN_ARTIFACT_ID = "download-maven-plugin";
    private String GET_FILE_PLUGIN_VERSION = "1.5.0";
    private MavenPluginParameters mavenPluginParameters;

    public PublicationStatusProvider(MavenPluginParameters mavenPluginParameters) {
        this.mavenPluginParameters = mavenPluginParameters;
    }

    public Status getStatus() {
        MavenProject mavenProject = this.mavenPluginParameters.getMavenProject();
        File tempDir = Files.createTempDir();
        File statusFile = null;
        try {
            String groupId = mavenProject.getGroupId();
            String assetId = mavenProject.getArtifactId();
            String version = mavenProject.getVersion();
            String classifier = "status-" + new Date().getTime();
            String packaging = "json";
            String fileName = groupId + ":" + assetId + ":" + version + ":" + classifier + ":" + packaging;
            Plugin deployFilePlugin = MojoExecutor.plugin((String)MojoExecutor.groupId((String)this.GET_FILE_PLUGIN_GROUP_ID), (String)MojoExecutor.artifactId((String)this.GET_FILE_PLUGIN_ARTIFACT_ID), (String)MojoExecutor.version((String)this.GET_FILE_PLUGIN_VERSION));
            String goal = MojoExecutor.goal((String)"artifact");
            Xpp3Dom pluginConfiguration = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)groupId), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)assetId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)version), MojoExecutor.element((String)MojoExecutor.name((String)"classifier"), (String)classifier), MojoExecutor.element((String)MojoExecutor.name((String)"type"), (String)"json"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)tempDir.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"outputFileName"), (String)fileName)});
            MojoExecutor.ExecutionEnvironment executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)this.mavenPluginParameters.getMavenProject(), (MavenSession)this.mavenPluginParameters.getMavenSession(), (BuildPluginManager)this.mavenPluginParameters.getPluginManager());
            MojoExecutor.executeMojo((Plugin)deployFilePlugin, (String)goal, (Xpp3Dom)pluginConfiguration, (MojoExecutor.ExecutionEnvironment)executionEnvironment);
            statusFile = new File(tempDir.getAbsolutePath(), fileName);
            Gson gson = new Gson();
            Status status = (Status)gson.fromJson((Reader)new FileReader(statusFile), Status.class);
            return status;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while getting the publication status", e);
        }
        finally {
            if (statusFile != null) {
                statusFile.delete();
            }
            tempDir.delete();
        }
    }
}

